/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xml;

import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlFile;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class XmlSchemaProvider {
    public static final ExtensionPointName<XmlSchemaProvider> EP_NAME = new ExtensionPointName("com.intellij.xml.schemaProvider");

    @Nullable
    public static XmlFile findSchema(@NotNull @NonNls String url, @Nullable Module module, @NotNull PsiFile file) {
        if (url == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/xml/XmlSchemaProvider.findSchema must not be null");
        }
        if (file == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/xml/XmlSchemaProvider.findSchema must not be null");
        }
        for (XmlSchemaProvider provider : (XmlSchemaProvider[])Extensions.getExtensions(EP_NAME)) {
            XmlFile schema = provider.getSchema(url, module, file);
            if (schema == null) continue;
            return schema;
        }
        return null;
    }

    @Nullable
    public static XmlFile findSchema(@NotNull @NonNls String url, @NotNull PsiFile baseFile) {
        PsiFile originalFile;
        if (url == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/xml/XmlSchemaProvider.findSchema must not be null");
        }
        if (baseFile == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/xml/XmlSchemaProvider.findSchema must not be null");
        }
        VirtualFile file = baseFile.getVirtualFile();
        if (file == null && (originalFile = baseFile.getOriginalFile()) != null) {
            file = originalFile.getVirtualFile();
        }
        Module module = file != null ? ProjectRootManager.getInstance(baseFile.getProject()).getFileIndex().getModuleForFile(file) : null;
        return XmlSchemaProvider.findSchema(url, module, baseFile);
    }

    @Nullable
    public abstract XmlFile getSchema(@NotNull @NonNls String var1, @Nullable Module var2, @NotNull PsiFile var3);
}

