/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcsUtil;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataKeys;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.actions.VcsContext;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.changes.VcsDirtyScopeManager;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.RefreshQueue;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.peer.PeerFactory;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlText;
import com.intellij.vcsUtil.VcsRunnable;
import com.intellij.vcsUtil.VcsSelection;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.Nullable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VcsUtil {
    protected static final char[] ourCharsToBeChopped = new char[]{'/', '\\'};

    public static void markFileAsDirty(Project project, final VirtualFile file) {
        final VcsDirtyScopeManager mgr = VcsDirtyScopeManager.getInstance(project);
        ApplicationManager.getApplication().runReadAction(new Runnable(){

            public void run() {
                mgr.fileDirty(file);
            }
        });
    }

    public static void markFileAsDirty(final Project project, final FilePath path) {
        ApplicationManager.getApplication().runReadAction(new Runnable(){

            public void run() {
                VcsDirtyScopeManager.getInstance(project).fileDirty(path);
            }
        });
    }

    public static void markFileAsDirty(Project project, String path) {
        FilePath filePath = PeerFactory.getInstance().getVcsContextFactory().createFilePathOn(new File(path));
        VcsUtil.markFileAsDirty(project, filePath);
    }

    public static void refreshFiles(Project project, HashSet<FilePath> paths) {
        for (FilePath path : paths) {
            VirtualFile vFile = path.getVirtualFile();
            if (vFile == null) continue;
            if (vFile.isDirectory()) {
                VcsUtil.markFileAsDirty(project, vFile);
                continue;
            }
            vFile.refresh(true, vFile.isDirectory());
        }
    }

    public static VcsSelection getSelection(VcsContext context) {
        VcsSelection selectionFromEditor = VcsUtil.getSelectionFromEditor(context);
        if (selectionFromEditor != null) {
            return selectionFromEditor;
        }
        return VcsUtil.getSelectionFromPsiElement(context);
    }

    @Nullable
    private static VcsSelection getSelectionFromPsiElement(VcsContext context) {
        String actionName;
        PsiElement psiElement = context.getPsiElement();
        if (psiElement == null) {
            return null;
        }
        if (!psiElement.isValid()) {
            return null;
        }
        if (psiElement instanceof PsiCompiledElement) {
            return null;
        }
        if (psiElement instanceof PsiClass) {
            actionName = VcsBundle.message("action.name.show.history.for.class", new Object[0]);
        } else if (psiElement instanceof PsiField) {
            actionName = VcsBundle.message("action.name.show.history.for.field", new Object[0]);
        } else if (psiElement instanceof PsiMethod) {
            actionName = VcsBundle.message("action.name.show.history.for.method", new Object[0]);
        } else if (psiElement instanceof XmlTag) {
            actionName = VcsBundle.message("action.name.show.history.for.tag", new Object[0]);
        } else if (psiElement instanceof XmlText) {
            actionName = VcsBundle.message("action.name.show.history.for.text", new Object[0]);
        } else if (psiElement instanceof PsiCodeBlock) {
            actionName = VcsBundle.message("action.name.show.history.for.code.block", new Object[0]);
        } else if (psiElement instanceof PsiStatement) {
            actionName = VcsBundle.message("action.name.show.history.for.statement", new Object[0]);
        } else {
            return null;
        }
        TextRange textRange = psiElement.getTextRange();
        if (textRange == null) {
            return null;
        }
        VirtualFile virtualFile = psiElement.getContainingFile().getVirtualFile();
        if (virtualFile == null) {
            return null;
        }
        if (!virtualFile.isValid()) {
            return null;
        }
        Document document = FileDocumentManager.getInstance().getDocument(virtualFile);
        return new VcsSelection(document, textRange, actionName);
    }

    private static VcsSelection getSelectionFromEditor(VcsContext context) {
        Editor editor = context.getEditor();
        if (editor == null) {
            return null;
        }
        SelectionModel selectionModel = editor.getSelectionModel();
        if (!selectionModel.hasSelection()) {
            return null;
        }
        return new VcsSelection(editor.getDocument(), selectionModel);
    }

    public static boolean isFileUnderVcs(Project project, String file) {
        return VcsUtil.getVcsFor(project, VcsUtil.getFilePath(file)) != null;
    }

    public static boolean isFileUnderVcs(Project project, FilePath file) {
        return VcsUtil.getVcsFor(project, file) != null;
    }

    public static boolean isFileForVcs(VirtualFile file, Project project, AbstractVcs host) {
        return VcsUtil.getVcsFor(project, file) == host;
    }

    public static boolean isFileForVcs(FilePath path, Project project, AbstractVcs host) {
        return VcsUtil.getVcsFor(project, path) == host;
    }

    public static boolean isFileForVcs(String path, Project project, AbstractVcs host) {
        return VcsUtil.getVcsFor(project, VcsUtil.getFilePath(path)) == host;
    }

    @Nullable
    public static AbstractVcs getVcsFor(final Project project, final FilePath file) {
        final AbstractVcs[] vcss = new AbstractVcs[1];
        ApplicationManager.getApplication().runReadAction(new Runnable(){

            public void run() {
                if (!project.isDisposed()) {
                    ProjectLevelVcsManager mgr = ProjectLevelVcsManager.getInstance(project);
                    vcss[0] = mgr != null ? mgr.getVcsFor(file) : null;
                }
            }
        });
        return vcss[0];
    }

    @Nullable
    public static AbstractVcs getVcsFor(final Project project, final VirtualFile file) {
        final AbstractVcs[] vcss = new AbstractVcs[1];
        ApplicationManager.getApplication().runReadAction(new Runnable(){

            public void run() {
                if (!project.isDisposed()) {
                    ProjectLevelVcsManager mgr = ProjectLevelVcsManager.getInstance(project);
                    vcss[0] = mgr != null ? mgr.getVcsFor(file) : null;
                }
            }
        });
        return vcss[0];
    }

    @Nullable
    public static VirtualFile getVcsRootFor(final Project project, final FilePath file) {
        final VirtualFile[] roots = new VirtualFile[1];
        ApplicationManager.getApplication().runReadAction(new Runnable(){

            public void run() {
                if (!project.isDisposed()) {
                    ProjectLevelVcsManager mgr = ProjectLevelVcsManager.getInstance(project);
                    roots[0] = mgr != null ? mgr.getVcsRootFor(file) : null;
                }
            }
        });
        return roots[0];
    }

    @Nullable
    public static VirtualFile getVcsRootFor(final Project project, final VirtualFile file) {
        final VirtualFile[] roots = new VirtualFile[1];
        ApplicationManager.getApplication().runReadAction(new Runnable(){

            public void run() {
                if (!project.isDisposed()) {
                    ProjectLevelVcsManager mgr = ProjectLevelVcsManager.getInstance(project);
                    roots[0] = mgr != null ? mgr.getVcsRootFor(file) : null;
                }
            }
        });
        return roots[0];
    }

    public static void refreshFiles(FilePath[] roots, Runnable runnable) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        VcsUtil.refreshFiles(VcsUtil.collectFilesToRefresh(roots), runnable);
    }

    public static void refreshFiles(File[] roots, Runnable runnable) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        VcsUtil.refreshFiles(VcsUtil.collectFilesToRefresh(roots), runnable);
    }

    private static File[] collectFilesToRefresh(FilePath[] roots) {
        File[] result = new File[roots.length];
        for (int i = 0; i < roots.length; ++i) {
            result[i] = roots[i].getIOFile();
        }
        return result;
    }

    private static void refreshFiles(List<VirtualFile> filesToRefresh, Runnable runnable) {
        RefreshQueue.getInstance().refresh(true, true, runnable, filesToRefresh.toArray(new VirtualFile[filesToRefresh.size()]));
    }

    private static List<VirtualFile> collectFilesToRefresh(File[] roots) {
        ArrayList<VirtualFile> result = new ArrayList<VirtualFile>();
        for (File root : roots) {
            VirtualFile vFile = VcsUtil.findFileFor(root);
            if (vFile == null) continue;
            result.add(vFile);
        }
        return result;
    }

    @Nullable
    private static VirtualFile findFileFor(File root) {
        for (File current = root; current != null; current = current.getParentFile()) {
            VirtualFile vFile = LocalFileSystem.getInstance().findFileByIoFile(root);
            if (vFile == null) continue;
            return vFile;
        }
        return null;
    }

    @Nullable
    public static VirtualFile getVirtualFile(final String path) {
        return ApplicationManager.getApplication().runReadAction(new Computable<VirtualFile>(){

            @Override
            @Nullable
            public VirtualFile compute() {
                return LocalFileSystem.getInstance().findFileByPath(path.replace(File.separatorChar, '/'));
            }
        });
    }

    @Nullable
    public static VirtualFile getVirtualFile(final File file) {
        return ApplicationManager.getApplication().runReadAction(new Computable<VirtualFile>(){

            @Override
            @Nullable
            public VirtualFile compute() {
                return LocalFileSystem.getInstance().findFileByIoFile(file);
            }
        });
    }

    public static String getFileContent(final String path) {
        return ApplicationManager.getApplication().runReadAction(new Computable<String>(){

            @Override
            public String compute() {
                VirtualFile vFile = VcsUtil.getVirtualFile(path);
                Document doc = FileDocumentManager.getInstance().getDocument(vFile);
                return doc.getText();
            }
        });
    }

    public static byte[] getFileByteContent(final File file) throws IOException {
        return ApplicationManager.getApplication().runReadAction(new Computable<byte[]>(){

            @Override
            public byte[] compute() {
                byte[] content;
                try {
                    content = FileUtil.loadFileBytes(file);
                }
                catch (IOException e) {
                    content = null;
                }
                return content;
            }
        });
    }

    public static boolean isPathUnderProject(Project project, String path) {
        VirtualFile vfPath = VcsUtil.getVirtualFile(path);
        return VcsUtil.isPathUnderProject(project, vfPath);
    }

    public static boolean isPathUnderProject(Project project, VirtualFile vf) {
        if (vf != null && !FileTypeManager.getInstance().isFileIgnored(vf.getPath())) {
            Module mod = ProjectRootManager.getInstance(project).getFileIndex().getModuleForFile(vf);
            return mod != null;
        }
        return false;
    }

    public static FilePath getFilePath(String path) {
        return VcsUtil.getFilePath(new File(path));
    }

    public static FilePath getFilePath(File file) {
        return PeerFactory.getInstance().getVcsContextFactory().createFilePathOn(file);
    }

    public static FilePath getFilePath(String path, boolean isDirectory) {
        return VcsUtil.getFilePath(new File(path), isDirectory);
    }

    public static FilePath getFilePath(File file, boolean isDirectory) {
        return PeerFactory.getInstance().getVcsContextFactory().createFilePathOn(file, isDirectory);
    }

    public static FilePath getFilePathForDeletedFile(String path, boolean isDirectory) {
        return PeerFactory.getInstance().getVcsContextFactory().createFilePathOnDeleted(new File(path), isDirectory);
    }

    public static void showErrorMessage(final Project project, final String message, final String title) {
        Runnable task = new Runnable(){

            public void run() {
                Messages.showErrorDialog(project, message, title);
            }
        };
        if (ApplicationManager.getApplication().isDispatchThread()) {
            task.run();
        } else {
            ApplicationManager.getApplication().invokeLater(task);
        }
    }

    public static void showStatusMessage(final Project project, final String message) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                if (project.isOpen()) {
                    WindowManager.getInstance().getStatusBar(project).setInfo(message);
                }
            }
        });
    }

    public static boolean isRenameChange(Change change) {
        boolean isRenamed = false;
        ContentRevision before = change.getBeforeRevision();
        ContentRevision after = change.getAfterRevision();
        if (before != null && after != null) {
            String newFile;
            String prevFile = VcsUtil.getCanonicalLocalPath(before.getFile().getPath());
            isRenamed = !prevFile.equals(newFile = VcsUtil.getCanonicalLocalPath(after.getFile().getPath()));
        }
        return isRenamed;
    }

    public static boolean isChangeForNew(Change change) {
        return change.getBeforeRevision() == null && change.getAfterRevision() != null;
    }

    public static boolean isChangeForDeleted(Change change) {
        return change.getBeforeRevision() != null && change.getAfterRevision() == null;
    }

    public static boolean isChangeForFolder(Change change) {
        ContentRevision revB = change.getBeforeRevision();
        ContentRevision revA = change.getAfterRevision();
        return revA != null && revA.getFile().isDirectory() || revB != null && revB.getFile().isDirectory();
    }

    public static FilePath[] sortPathsFromInnermost(FilePath[] files) {
        return VcsUtil.sortPaths(files, -1);
    }

    public static FilePath[] sortPathsFromOutermost(FilePath[] files) {
        return VcsUtil.sortPaths(files, 1);
    }

    private static FilePath[] sortPaths(FilePath[] files, final int sign) {
        Arrays.sort(files, new Comparator<FilePath>(){

            @Override
            public int compare(FilePath o1, FilePath o2) {
                return sign * o1.getPath().compareTo(o2.getPath());
            }
        });
        return files;
    }

    @Nullable
    public static VirtualFile getOneVirtualFile(AnActionEvent e) {
        VirtualFile[] files = VcsUtil.getVirtualFiles(e);
        return files.length != 1 ? null : files[0];
    }

    public static VirtualFile[] getVirtualFiles(AnActionEvent e) {
        VirtualFile[] files = e.getData(DataKeys.VIRTUAL_FILE_ARRAY);
        return files == null ? VirtualFile.EMPTY_ARRAY : files;
    }

    public static void collectFiles(VirtualFile dir, List files, boolean recursive, boolean addDirectories) {
        VirtualFile[] children;
        if (!dir.isDirectory()) {
            throw new IllegalArgumentException(VcsBundle.message("exception.text.file.should.be.directory", dir.getPresentableUrl()));
        }
        FileTypeManager fileTypeManager = FileTypeManager.getInstance();
        for (VirtualFile child : children = dir.getChildren()) {
            if (!(child.isDirectory() || fileTypeManager != null && fileTypeManager.getFileTypeByFile(child) == StdFileTypes.UNKNOWN)) {
                files.add(child);
                continue;
            }
            if (!recursive || !child.isDirectory()) continue;
            if (addDirectories) {
                files.add(child);
            }
            VcsUtil.collectFiles(child, files, recursive, false);
        }
    }

    public static boolean runVcsProcessWithProgress(final VcsRunnable runnable, String progressTitle, boolean canBeCanceled, Project project) throws VcsException {
        final Ref ex = new Ref();
        boolean result = ProgressManager.getInstance().runProcessWithProgressSynchronously(new Runnable(){

            public void run() {
                try {
                    runnable.run();
                }
                catch (VcsException e) {
                    ex.set(e);
                }
            }
        }, progressTitle, canBeCanceled, project);
        if (!ex.isNull()) {
            throw (VcsException)ex.get();
        }
        return result;
    }

    public static VirtualFile waitForTheFile(final String path) {
        final VirtualFile[] file = new VirtualFile[1];
        final Application app = ApplicationManager.getApplication();
        Runnable action = new Runnable(){

            public void run() {
                app.runWriteAction(new Runnable(){

                    public void run() {
                        file[0] = LocalFileSystem.getInstance().refreshAndFindFileByPath(path);
                    }
                });
            }
        };
        if (app.isDispatchThread()) {
            action.run();
        } else {
            app.invokeAndWait(action, ModalityState.defaultModalityState());
        }
        return file[0];
    }

    public static String getCanonicalLocalPath(String localPath) {
        if ((localPath = VcsUtil.chopTrailingChars(localPath.trim().replace('\\', '/'), ourCharsToBeChopped)).length() == 2 && localPath.charAt(1) == ':') {
            localPath = localPath + '/';
        }
        return localPath;
    }

    public static String getCanonicalPath(String path) {
        String canonPath;
        try {
            canonPath = new File(path).getCanonicalPath();
        }
        catch (IOException e) {
            canonPath = path;
        }
        return canonPath;
    }

    public static String getCanonicalPath(File file) {
        String canonPath;
        try {
            canonPath = file.getCanonicalPath();
        }
        catch (IOException e) {
            canonPath = file.getAbsolutePath();
        }
        return canonPath;
    }

    public static String chopTrailingChars(String source, char[] chars) {
        boolean atLeastOneCharWasChopped;
        StringBuffer sb = new StringBuffer(source);
        do {
            atLeastOneCharWasChopped = false;
            for (int i = 0; i < chars.length && sb.length() > 0; ++i) {
                if (sb.charAt(sb.length() - 1) != chars[i]) continue;
                sb.deleteCharAt(sb.length() - 1);
                atLeastOneCharWasChopped = true;
            }
        } while (atLeastOneCharWasChopped);
        return sb.toString();
    }

    public static VirtualFile[] paths2VFiles(String[] paths) {
        VirtualFile[] files = new VirtualFile[paths.length];
        for (int i = 0; i < paths.length; ++i) {
            files[i] = VcsUtil.getVirtualFile(paths[i]);
        }
        return files;
    }
}

