/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xmlb;

import com.intellij.openapi.util.JDOMUtil;
import com.intellij.util.xmlb.Accessor;
import com.intellij.util.xmlb.BeanBinding;
import com.intellij.util.xmlb.Binding;
import com.intellij.util.xmlb.JDOMXIncluder;
import com.intellij.util.xmlb.SerializationFilter;
import com.intellij.util.xmlb.XmlSerializationException;
import com.intellij.util.xmlb.XmlSerializerImpl;
import java.io.IOException;
import java.lang.reflect.Array;
import java.net.URL;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jetbrains.annotations.Nullable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XmlSerializer {
    private static final SerializationFilter TRUE_FILTER = new SerializationFilter(){

        public boolean accepts(Accessor accessor, Object bean) {
            return true;
        }
    };

    private XmlSerializer() {
    }

    public static Element serialize(Object object) throws XmlSerializationException {
        return XmlSerializer.serialize(object, TRUE_FILTER);
    }

    public static Element serialize(Object object, SerializationFilter filter) throws XmlSerializationException {
        if (filter == null) {
            filter = TRUE_FILTER;
        }
        return new XmlSerializerImpl(filter).serialize(object);
    }

    @Nullable
    public static <T> T deserialize(Document document, Class<T> aClass) throws XmlSerializationException {
        return XmlSerializer.deserialize(document.getRootElement(), aClass);
    }

    @Nullable
    public static <T> T deserialize(Element element, Class<T> aClass) throws XmlSerializationException {
        try {
            XmlSerializerImpl serializer = new XmlSerializerImpl(TRUE_FILTER);
            return (T)serializer.getBinding(aClass).deserialize(null, element);
        }
        catch (XmlSerializationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new XmlSerializationException(e);
        }
    }

    public static <T> T[] deserialize(Element[] elements, Class<T> aClass) throws XmlSerializationException {
        Object[] result = (Object[])Array.newInstance(aClass, elements.length);
        for (int i = 0; i < result.length; ++i) {
            result[i] = XmlSerializer.deserialize(elements[i], aClass);
        }
        return result;
    }

    @Nullable
    public static <T> T deserialize(URL url, Class<T> aClass) throws XmlSerializationException {
        try {
            Document document = JDOMUtil.loadDocument(url);
            document = JDOMXIncluder.resolve(document, url.toExternalForm());
            return XmlSerializer.deserialize(document.getRootElement(), aClass);
        }
        catch (IOException e) {
            throw new XmlSerializationException(e);
        }
        catch (JDOMException e) {
            throw new XmlSerializationException(e);
        }
    }

    public static void deserializeInto(Object bean, Element element) {
        try {
            XmlSerializerImpl serializer = new XmlSerializerImpl(TRUE_FILTER);
            Binding binding = serializer.getBinding(bean.getClass());
            assert (binding instanceof BeanBinding);
            ((BeanBinding)binding).deserializeInto(bean, element);
        }
        catch (XmlSerializationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new XmlSerializationException(e);
        }
    }
}

