/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xmlb;

import com.intellij.util.xmlb.Accessor;
import com.intellij.util.xmlb.Binding;
import com.intellij.util.xmlb.XmlSerializationException;
import com.intellij.util.xmlb.XmlSerializerImpl;
import org.jdom.Content;
import org.jdom.Text;
import org.jetbrains.annotations.Nullable;

public class TextBinding
implements Binding {
    private Accessor myAccessor;
    private XmlSerializerImpl myXmlSerializer;
    private Binding myBinding;

    public TextBinding(Accessor accessor, XmlSerializerImpl xmlSerializer) {
        this.myAccessor = accessor;
        this.myXmlSerializer = xmlSerializer;
    }

    public Object serialize(Object o, Object context) {
        Object v = this.myAccessor.read(o);
        Object node = this.myBinding.serialize(v, context);
        return new Text(((Content)node).getValue());
    }

    @Nullable
    public Object deserialize(Object context, Object ... nodes) {
        assert (nodes.length == 1);
        Object node = nodes[0];
        assert (this.isBoundTo(node));
        this.myAccessor.write(context, this.myBinding.deserialize(context, nodes[0]));
        return context;
    }

    public boolean isBoundTo(Object node) {
        return node instanceof Text;
    }

    public Class getBoundNodeType() {
        return Text.class;
    }

    public void init() {
        this.myBinding = this.myXmlSerializer.getBinding(this.myAccessor);
        if (!Text.class.isAssignableFrom(this.myBinding.getBoundNodeType())) {
            throw new XmlSerializationException("Can't use attribute binding for non-text content: " + this.myAccessor);
        }
    }
}

