/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xmlb;

import com.intellij.openapi.util.JDOMUtil;
import com.intellij.util.xmlb.Accessor;
import com.intellij.util.xmlb.Binding;
import com.intellij.util.xmlb.XmlSerializerImpl;
import com.intellij.util.xmlb.annotations.Tag;
import java.util.ArrayList;
import java.util.Arrays;
import org.jdom.Content;
import org.jdom.Element;
import org.jdom.Text;

class TagBinding
implements Binding {
    private Accessor accessor;
    private Tag myTagAnnotation;
    private String myTagName;
    private Binding binding;

    public TagBinding(Accessor accessor, Tag tagAnnotation, XmlSerializerImpl xmlSerializer) {
        this.accessor = accessor;
        this.myTagAnnotation = tagAnnotation;
        this.myTagName = tagAnnotation.value();
        this.binding = xmlSerializer.getBinding(accessor);
    }

    public Object serialize(Object o, Object context) {
        Object value = this.accessor.read(o);
        if (value == null) {
            return context;
        }
        Element v = new Element(this.myTagName);
        Object node = this.binding.serialize(value, v);
        if (node != v) {
            JDOMUtil.addContent(v, node);
        }
        return v;
    }

    public Object deserialize(Object o, Object ... nodes) {
        Object[] children;
        assert (nodes.length > 0);
        if (nodes.length == 1) {
            children = JDOMUtil.getContent((Element)nodes[0]);
        } else {
            String name = ((Element)nodes[0]).getName();
            ArrayList<Content> childrenList = new ArrayList<Content>();
            for (Object node : nodes) {
                assert (((Element)node).getName().equals(name));
                childrenList.addAll(Arrays.asList(JDOMUtil.getContent((Element)node)));
            }
            children = childrenList.toArray(new Object[childrenList.size()]);
        }
        if (children.length == 0) {
            children = new Object[]{new Text(this.myTagAnnotation.textIfEmpty())};
        }
        Object v = this.binding.deserialize(this.accessor.read(o), children);
        Object value = XmlSerializerImpl.convert(v, this.accessor.getValueClass());
        this.accessor.write(o, value);
        return o;
    }

    public boolean isBoundTo(Object node) {
        return node instanceof Element && ((Element)node).getName().equals(this.myTagName);
    }

    public Class getBoundNodeType() {
        throw new UnsupportedOperationException("Method getBoundNodeType is not supported in " + this.getClass());
    }

    public void init() {
    }
}

