/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xmlb;

import com.intellij.openapi.util.Comparing;
import com.intellij.util.xmlb.Accessor;
import com.intellij.util.xmlb.SerializationFilter;
import com.intellij.util.xmlb.XmlSerializationException;
import java.util.HashMap;
import java.util.Map;

public class SkipDefaultValuesSerializationFilters
implements SerializationFilter {
    private Map<Class, Object> myDefaultBeans = new HashMap<Class, Object>();

    public boolean accepts(Accessor accessor, Object bean) {
        Object defaultBean = this.getDefaultBean(bean);
        return !Comparing.equal(accessor.read(bean), accessor.read(defaultBean));
    }

    private Object getDefaultBean(Object bean) {
        Class<?> c = bean.getClass();
        Object o = this.myDefaultBeans.get(c);
        if (o == null) {
            try {
                o = c.newInstance();
                this.configure(o);
            }
            catch (InstantiationException e) {
                throw new XmlSerializationException(e);
            }
            catch (IllegalAccessException e) {
                throw new XmlSerializationException(e);
            }
            this.myDefaultBeans.put(c, o);
        }
        return o;
    }

    protected void configure(Object o) {
    }
}

