/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xmlb;

import com.intellij.util.xmlb.Accessor;
import com.intellij.util.xmlb.Binding;
import com.intellij.util.xmlb.XmlSerializerImpl;
import com.intellij.util.xmlb.annotations.Tag;
import org.jdom.Element;
import org.jetbrains.annotations.Nullable;

class JDOMElementBinding
implements Binding {
    private Accessor myAccessor;
    private String myTagName;

    public JDOMElementBinding(Accessor accessor) {
        this.myAccessor = accessor;
        Tag tag = XmlSerializerImpl.findAnnotation(this.myAccessor.getAnnotations(), Tag.class);
        assert (tag != null) : "jdom.Element property without @Tag annotation: " + accessor;
        this.myTagName = tag.value();
    }

    public Object serialize(Object o, Object context) {
        throw new UnsupportedOperationException("Method serialize is not supported in " + this.getClass());
    }

    @Nullable
    public Object deserialize(Object context, Object ... nodes) {
        Element[] result = new Element[nodes.length];
        System.arraycopy(nodes, 0, result, 0, nodes.length);
        if (this.myAccessor.getValueClass().isArray()) {
            this.myAccessor.write(context, result);
        } else {
            assert (result.length == 1);
            this.myAccessor.write(context, result[0]);
        }
        return context;
    }

    public boolean isBoundTo(Object node) {
        return node instanceof Element && ((Element)node).getName().equals(this.myTagName);
    }

    public Class getBoundNodeType() {
        throw new UnsupportedOperationException("Method getBoundNodeType is not supported in " + this.getClass());
    }

    public void init() {
    }
}

