/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xmlb;

import com.intellij.util.xmlb.Accessor;
import com.intellij.util.xmlb.XmlSerializationException;
import com.intellij.util.xmlb.XmlSerializerImpl;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import org.jetbrains.annotations.NonNls;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class FieldAccessor
implements Accessor {
    private final Field myField;

    public FieldAccessor(Field myField) {
        this.myField = myField;
    }

    @Override
    public Object read(Object o) {
        assert (this.myField.getDeclaringClass().isInstance(o)) : "Wrong class: " + o.getClass() + " should be: " + this.myField.getDeclaringClass();
        try {
            return this.myField.get(o);
        }
        catch (IllegalAccessException e) {
            throw new XmlSerializationException(e);
        }
    }

    @Override
    public void write(Object o, Object value) {
        assert (this.myField.getDeclaringClass().isInstance(o)) : "Wrong class: " + o.getClass() + " should be: " + this.myField.getDeclaringClass();
        try {
            this.myField.set(o, XmlSerializerImpl.convert(value, this.myField.getType()));
        }
        catch (IllegalAccessException e) {
            throw new XmlSerializationException(e);
        }
    }

    @Override
    public Annotation[] getAnnotations() {
        return this.myField.getAnnotations();
    }

    @Override
    public String getName() {
        return this.myField.getName();
    }

    @Override
    public Class<?> getValueClass() {
        return this.myField.getType();
    }

    @Override
    public Type getGenericType() {
        return this.myField.getGenericType();
    }

    @NonNls
    public String toString() {
        return "FieldAccessor[" + this.myField.getDeclaringClass() + "." + this.myField.getName() + "]";
    }
}

