/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xmlb;

import com.intellij.util.xmlb.AbstractCollectionBinding;
import com.intellij.util.xmlb.Accessor;
import com.intellij.util.xmlb.XmlSerializerImpl;
import java.lang.reflect.ParameterizedType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;

class CollectionBinding
extends AbstractCollectionBinding {
    public CollectionBinding(ParameterizedType type, XmlSerializerImpl xmlSerializer, Accessor accessor) {
        super((Class)type.getActualTypeArguments()[0], xmlSerializer, "collection", accessor);
    }

    Object processResult(Collection result, Object target) {
        if (this.myAccessor == null) {
            return result;
        }
        assert (target instanceof Collection) : "Wrong target: " + target.getClass() + " in " + this.myAccessor;
        Collection c = (Collection)target;
        c.clear();
        c.addAll(result);
        return target;
    }

    Iterable getIterable(Object o) {
        if (o instanceof Set) {
            Set set = (Set)o;
            return new TreeSet(set);
        }
        return (Collection)o;
    }

    protected String getCollectionTagName(Object target) {
        if (target instanceof Set) {
            return "set";
        }
        if (target instanceof List) {
            return "list";
        }
        return super.getCollectionTagName(target);
    }

    protected Collection createCollection(String tagName) {
        if (tagName.equals("set")) {
            return new HashSet();
        }
        if (tagName.equals("list")) {
            return new ArrayList();
        }
        return super.createCollection(tagName);
    }
}

