/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xmlb;

import com.intellij.util.xmlb.Accessor;
import com.intellij.util.xmlb.Binding;
import com.intellij.util.xmlb.XmlSerializationException;
import com.intellij.util.xmlb.XmlSerializerImpl;
import com.intellij.util.xmlb.annotations.Attribute;
import org.jdom.Content;
import org.jdom.Text;
import org.jetbrains.annotations.Nullable;

public class AttributeBinding
implements Binding {
    private Accessor myAccessor;
    private Attribute myAttribute;
    private XmlSerializerImpl myXmlSerializer;
    private Binding myBinding;

    public AttributeBinding(Accessor accessor, Attribute attribute, XmlSerializerImpl xmlSerializer) {
        this.myAccessor = accessor;
        this.myAttribute = attribute;
        this.myXmlSerializer = xmlSerializer;
    }

    public Object serialize(Object o, Object context) {
        Object v = this.myAccessor.read(o);
        Object node = this.myBinding.serialize(v, context);
        return new org.jdom.Attribute(this.myAttribute.value(), ((Content)node).getValue());
    }

    @Nullable
    public Object deserialize(Object context, Object ... nodes) {
        assert (nodes.length == 1);
        Object node = nodes[0];
        assert (this.isBoundTo(node));
        org.jdom.Attribute attr = (org.jdom.Attribute)node;
        String value = attr.getValue();
        Text text = new Text(value);
        this.myAccessor.write(context, this.myBinding.deserialize(context, text));
        return context;
    }

    public boolean isBoundTo(Object node) {
        return node instanceof org.jdom.Attribute && ((org.jdom.Attribute)node).getName().equals(this.myAttribute.value());
    }

    public Class getBoundNodeType() {
        return org.jdom.Attribute.class;
    }

    public void init() {
        this.myBinding = this.myXmlSerializer.getBinding(this.myAccessor);
        if (!Text.class.isAssignableFrom(this.myBinding.getBoundNodeType())) {
            throw new XmlSerializationException("Can't use attribute binding for non-text content: " + this.myAccessor);
        }
    }
}

