/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xmlb;

import com.intellij.openapi.util.JDOMUtil;
import com.intellij.util.xmlb.Accessor;
import com.intellij.util.xmlb.Binding;
import com.intellij.util.xmlb.TagBindingWrapper;
import com.intellij.util.xmlb.XmlSerializationException;
import com.intellij.util.xmlb.XmlSerializerImpl;
import com.intellij.util.xmlb.annotations.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.jdom.Content;
import org.jdom.Element;
import org.jetbrains.annotations.Nullable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class AbstractCollectionBinding
implements Binding {
    private Map<Class, Binding> myElementBindings;
    private Class myElementType;
    private XmlSerializerImpl myXmlSerializer;
    private String myTagName;
    @Nullable
    protected Accessor myAccessor;
    private AbstractCollection myAnnotation = null;
    private boolean myUsingOptionBinding = false;

    public AbstractCollectionBinding(Class elementType, XmlSerializerImpl xmlSerializer, String tagName, @Nullable Accessor accessor) {
        this.myElementType = elementType;
        this.myXmlSerializer = xmlSerializer;
        this.myTagName = tagName;
        this.myAccessor = accessor;
        if (accessor != null) {
            this.myAnnotation = XmlSerializerImpl.findAnnotation(accessor.getAnnotations(), AbstractCollection.class);
        }
    }

    @Override
    public void init() {
        if (this.myAnnotation != null && !this.myAnnotation.surroundWithTag()) {
            if (this.myAnnotation.elementTag() == null) {
                throw new XmlSerializationException("If surround with tag is turned off, element tag must be specified for: " + this.myAccessor);
            }
            if (this.myAnnotation.elementTag().equals("option")) {
                this.getElementBindings();
                if (this.myUsingOptionBinding) {
                    throw new XmlSerializationException("If surround with tag is turned off, element tag must be specified for: " + this.myAccessor);
                }
            }
        }
    }

    protected Binding getElementBinding(Class<? extends Object> elementClass) {
        Binding binding = this.getElementBindings().get(elementClass);
        if (binding == null) {
            throw new XmlSerializationException("Class " + elementClass + " is not bound");
        }
        return binding;
    }

    private Map<Class, Binding> getElementBindings() {
        if (this.myElementBindings == null) {
            this.myElementBindings = new HashMap<Class, Binding>();
            this.myElementBindings.put(this.myElementType, this.getBinding(this.myElementType));
            if (this.myAnnotation != null) {
                for (Class aClass : this.myAnnotation.elementTypes()) {
                    this.myElementBindings.put(aClass, this.getBinding(aClass));
                }
            }
        }
        return this.myElementBindings;
    }

    protected Binding getElementBinding(Object node) {
        for (Binding binding : this.getElementBindings().values()) {
            if (!binding.isBoundTo(node)) continue;
            return binding;
        }
        throw new XmlSerializationException("Node " + node + " is not bound");
    }

    private Binding getBinding(Class type) {
        Binding binding = this.myXmlSerializer.getBinding(type);
        if (!binding.getBoundNodeType().isAssignableFrom(Element.class)) {
            binding = this.createElementTagWrapper(binding);
            this.myUsingOptionBinding = true;
        }
        return binding;
    }

    private Binding createElementTagWrapper(Binding elementBinding) {
        if (this.myAnnotation == null) {
            return new TagBindingWrapper(elementBinding, "option", "value");
        }
        return new TagBindingWrapper(elementBinding, this.myAnnotation.elementTag() != null ? this.myAnnotation.elementTag() : "option", this.myAnnotation.elementValueAttribute() != null ? this.myAnnotation.elementValueAttribute() : "value");
    }

    abstract Object processResult(Collection var1, Object var2);

    abstract Iterable getIterable(Object var1);

    @Override
    public Object serialize(Object o, Object context) {
        Iterable iterable = this.getIterable(o);
        if (iterable == null) {
            return context;
        }
        String tagName = this.getTagName(o);
        if (tagName != null) {
            Element result = new Element(tagName);
            for (Object e : iterable) {
                Binding binding = this.getElementBinding(e.getClass());
                result.addContent((Content)binding.serialize(e, result));
            }
            return result;
        }
        ArrayList<Object> result = new ArrayList<Object>();
        for (Object e : iterable) {
            Binding binding = this.getElementBinding(e.getClass());
            result.add(binding.serialize(e, result));
        }
        return result;
    }

    @Override
    public Object deserialize(Object o, Object ... nodes) {
        Collection<Object> result;
        if (this.getTagName(o) != null) {
            Content[] childElements;
            assert (nodes.length == 1);
            Element e = (Element)nodes[0];
            result = this.createCollection(e.getName());
            for (Content n : childElements = JDOMUtil.getContent(e)) {
                if (XmlSerializerImpl.isIgnoredNode(n)) continue;
                Binding elementBinding = this.getElementBinding(n);
                Object v = elementBinding.deserialize(o, n);
                result.add(v);
            }
        } else {
            result = new ArrayList();
            for (Object node : nodes) {
                if (XmlSerializerImpl.isIgnoredNode(node)) continue;
                Binding elementBinding = this.getElementBinding(node);
                Object v = elementBinding.deserialize(o, node);
                result.add(v);
            }
        }
        return this.processResult(result, o);
    }

    protected Collection createCollection(String tagName) {
        return new ArrayList();
    }

    @Override
    public boolean isBoundTo(Object node) {
        if (!(node instanceof Element)) {
            return false;
        }
        String tagName = this.getTagName(node);
        if (tagName == null) {
            for (Binding binding : this.getElementBindings().values()) {
                if (!binding.isBoundTo(node)) continue;
                return true;
            }
        }
        return ((Element)node).getName().equals(tagName);
    }

    @Override
    public Class getBoundNodeType() {
        return Element.class;
    }

    public Class getElementType() {
        return this.myElementType;
    }

    @Nullable
    private String getTagName(Object target) {
        if (this.myAnnotation == null || this.myAnnotation.surroundWithTag()) {
            return this.getCollectionTagName(target);
        }
        return null;
    }

    protected String getCollectionTagName(Object target) {
        return this.myTagName;
    }
}

