/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml.ui.actions.generate;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlElement;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.reflect.DomCollectionChildDescription;
import com.intellij.util.xml.ui.actions.generate.GenerateDomElementProvider;
import java.util.List;
import org.jetbrains.annotations.Nullable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DefaultGenerateElementProvider<T extends DomElement>
extends GenerateDomElementProvider<T> {
    private Class<? extends DomElement> myChildElementClass;

    public DefaultGenerateElementProvider(String name, Class<T> childElementClass) {
        super(name);
        this.myChildElementClass = childElementClass;
    }

    @Override
    @Nullable
    public T generate(Project project, Editor editor, PsiFile file) {
        return this.generate(this.getParentDomElement(project, editor, file), editor);
    }

    @Nullable
    protected abstract DomElement getParentDomElement(Project var1, Editor var2, PsiFile var3);

    @Nullable
    public T generate(@Nullable DomElement parent, Editor editor) {
        if (parent != null) {
            List<? extends DomCollectionChildDescription> list = parent.getGenericInfo().getCollectionChildrenDescriptions();
            for (DomCollectionChildDescription domCollectionChildDescription : list) {
                if (!ReflectionUtil.getRawType(domCollectionChildDescription.getType()).isAssignableFrom(this.myChildElementClass)) continue;
                int index = DefaultGenerateElementProvider.getCollectionIndex(parent, domCollectionChildDescription, editor);
                return (T)(index < 0 ? domCollectionChildDescription.addValue(parent, this.myChildElementClass) : domCollectionChildDescription.addValue(parent, this.myChildElementClass, index));
            }
        }
        return null;
    }

    private static int getCollectionIndex(DomElement parent, DomCollectionChildDescription childDescription, Editor editor) {
        int offset = editor.getCaretModel().getOffset();
        for (int i = 0; i < childDescription.getValues(parent).size(); ++i) {
            DomElement element = childDescription.getValues(parent).get(i);
            XmlElement xmlElement = element.getXmlElement();
            if (xmlElement == null || xmlElement.getTextRange().getStartOffset() < offset) continue;
            return i;
        }
        return -1;
    }
}

