/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml.ui;

import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.util.IconLoader;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.highlighting.DomElementAnnotationsManager;
import com.intellij.util.xml.highlighting.DomElementProblemDescriptor;
import com.intellij.util.xml.highlighting.DomElementsProblemsHolder;
import com.intellij.util.xml.ui.BaseControl;
import com.intellij.util.xml.ui.TooltipUtils;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ErrorableTableCellRenderer<T extends DomElement>
extends DefaultTableCellRenderer {
    private final TableCellRenderer myRenderer;
    private final DomElement myRowDomElement;
    private T myCellValueDomElement;

    public ErrorableTableCellRenderer(T cellValueDomElement, TableCellRenderer renderer, DomElement rowDomElement) {
        this.myCellValueDomElement = cellValueDomElement;
        this.myRenderer = renderer;
        this.myRowDomElement = rowDomElement;
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        boolean hasErrors;
        Component component = this.myRenderer.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        DomElementAnnotationsManager annotationsManager = DomElementAnnotationsManager.getInstance(this.myRowDomElement.getManager().getProject());
        DomElementsProblemsHolder holder = annotationsManager.getCachedProblemHolder((DomElement)this.myCellValueDomElement);
        List<DomElementProblemDescriptor> errorProblems = holder.getProblems((DomElement)this.myCellValueDomElement);
        ArrayList<DomElementProblemDescriptor> warningProblems = new ArrayList<DomElementProblemDescriptor>(holder.getProblems((DomElement)this.myCellValueDomElement, true, HighlightSeverity.WARNING));
        warningProblems.removeAll(errorProblems);
        boolean bl = hasErrors = errorProblems.size() > 0;
        if (hasErrors) {
            component.setForeground(Color.RED);
            if (component instanceof JComponent) {
                ((JComponent)component).setToolTipText(TooltipUtils.getTooltipText(errorProblems));
            }
        } else {
            component.setForeground(isSelected ? table.getSelectionForeground() : table.getForeground());
            if (component instanceof JComponent) {
                ((JComponent)component).setToolTipText(null);
            }
        }
        if (hasErrors && (value == null || value.toString().trim().length() == 0)) {
            component.setBackground(BaseControl.ERROR_BACKGROUND);
        } else if (warningProblems.size() > 0) {
            component.setBackground(BaseControl.WARNING_BACKGROUND);
            if (isSelected) {
                component.setForeground(Color.BLACK);
            }
        }
        List<DomElementProblemDescriptor> errorDescriptors = annotationsManager.getCachedProblemHolder(this.myRowDomElement).getProblems(this.myRowDomElement, true, true);
        if (table.getModel().getColumnCount() - 1 == column) {
            if (errorDescriptors.size() > 0) {
                JPanel wrapper = new JPanel(new BorderLayout());
                wrapper.add(component, "Center");
                wrapper.setBackground(component.getBackground());
                JLabel errorLabel = new JLabel(ErrorableTableCellRenderer.getErrorIcon());
                wrapper.setToolTipText(TooltipUtils.getTooltipText(errorDescriptors));
                wrapper.add((Component)errorLabel, "East");
                if (component instanceof JComponent) {
                    JComponent jComponent = (JComponent)component;
                    wrapper.setBorder(jComponent.getBorder());
                    jComponent.setBorder(BorderFactory.createEmptyBorder());
                    jComponent.setToolTipText(TooltipUtils.getTooltipText(errorDescriptors));
                }
                return wrapper;
            }
            if (component instanceof JComponent) {
                ((JComponent)component).setToolTipText(null);
            }
        }
        return component;
    }

    private static Icon getErrorIcon() {
        return IconLoader.getIcon("/general/exclMark.png");
    }
}

