/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml.ui;

import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.DataSink;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.TypeSafeDataProvider;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import com.intellij.util.SmartList;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.ui.AbstractTableView;
import java.util.List;
import org.jetbrains.annotations.NotNull;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DomTableView
extends AbstractTableView<DomElement> {
    private final List<TypeSafeDataProvider> myCustomDataProviders = new SmartList<TypeSafeDataProvider>();

    public DomTableView(Project project) {
        super(project);
    }

    public DomTableView(Project project, String emptyPaneText, String helpID) {
        super(project, emptyPaneText, helpID);
    }

    public void addCustomDataProvider(TypeSafeDataProvider provider) {
        this.myCustomDataProviders.add(provider);
    }

    @Override
    public void calcData(DataKey key, DataSink sink) {
        super.calcData(key, sink);
        for (TypeSafeDataProvider customDataProvider : this.myCustomDataProviders) {
            customDataProvider.calcData(key, sink);
        }
    }

    @Deprecated
    protected final void installPopup(DefaultActionGroup group) {
        this.installPopup("J2EEAttributesViewPopup", group);
    }

    @Override
    protected void wrapValueSetting(@NotNull DomElement domElement, final Runnable valueSetter) {
        if (domElement == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/xml/ui/DomTableView.wrapValueSetting must not be null");
        }
        if (domElement.isValid()) {
            new WriteCommandAction(this.getProject(), new PsiFile[]{domElement.getRoot().getFile()}){

                protected void run(Result result) throws Throwable {
                    valueSetter.run();
                }
            }.execute();
            this.fireChanged();
        }
    }
}

