/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml.ui;

import com.intellij.openapi.util.Disposer;
import com.intellij.util.xml.ui.Committable;
import com.intellij.util.xml.ui.CommittableUtil;
import com.intellij.util.xml.ui.Highlightable;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompositeCommittable
implements Committable,
Highlightable {
    private final List<Committable> myComponents = new ArrayList<Committable>();

    public final <T extends Committable> T addComponent(T panel) {
        this.myComponents.add(panel);
        Disposer.register(this, panel);
        return panel;
    }

    @Override
    public void commit() {
        for (Committable committable : this.myComponents) {
            committable.commit();
        }
    }

    @Override
    public void reset() {
        for (Committable committable : this.myComponents) {
            committable.reset();
        }
    }

    @Override
    public void dispose() {
    }

    public List<Committable> getChildren() {
        return this.myComponents;
    }

    @Override
    public void updateHighlighting() {
        for (Committable component : this.myComponents) {
            CommittableUtil.updateHighlighting(component);
        }
    }
}

