/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml.ui;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.ui.UserActivityListener;
import com.intellij.util.Alarm;
import com.intellij.util.xml.ui.Committable;
import com.intellij.util.xml.ui.CommittableUtil;

public class CommitablePanelUserActivityListener
implements UserActivityListener,
Disposable {
    private final Committable myPanel;
    private final Project myProject;
    private final Alarm myAlarm = new Alarm();
    private boolean myApplying;

    public CommitablePanelUserActivityListener(Project project) {
        this(null, project);
    }

    public CommitablePanelUserActivityListener(Committable panel, Project project) {
        this.myPanel = panel;
        this.myProject = project;
    }

    public final void stateChanged() {
        if (this.myApplying) {
            return;
        }
        CommitablePanelUserActivityListener.cancel();
        this.cancelAllRequests();
        this.myAlarm.addRequest(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                CommitablePanelUserActivityListener.this.myApplying = true;
                CommitablePanelUserActivityListener.cancel();
                try {
                    CommitablePanelUserActivityListener.this.applyChanges();
                }
                finally {
                    CommitablePanelUserActivityListener.this.myApplying = false;
                }
            }
        }, 717);
    }

    private static void cancel() {
        ProgressIndicator indicator = ProgressManager.getInstance().getProgressIndicator();
        if (indicator != null) {
            indicator.cancel();
        }
    }

    protected void applyChanges() {
        if (this.myPanel != null) {
            this.commit(this.myPanel);
        }
    }

    protected final void commit(Committable panel) {
        ServiceManager.getService(this.getProject(), CommittableUtil.class).commit(panel);
    }

    protected final Project getProject() {
        return this.myProject;
    }

    public final boolean isWaiting() {
        return this.myAlarm.getActiveRequestCount() > 0;
    }

    public final void cancelAllRequests() {
        this.myAlarm.cancelAllRequests();
    }

    public void dispose() {
        this.cancelAllRequests();
    }
}

