/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml.ui;

import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Factory;
import com.intellij.openapi.util.Pair;
import com.intellij.util.containers.HashMap;
import com.intellij.util.xml.ui.ComboControl;
import java.awt.Component;
import java.util.List;
import java.util.Map;
import javax.swing.DefaultCellEditor;
import javax.swing.Icon;
import javax.swing.JComboBox;
import javax.swing.JTable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ComboTableCellEditor
extends DefaultCellEditor {
    private final boolean myNullable;
    private final Factory<List<Pair<String, Icon>>> myDataFactory;
    private Map<String, Icon> myData;
    private static final Pair<String, Icon> EMPTY = Pair.create(" ", null);

    public ComboTableCellEditor(Factory<List<Pair<String, Icon>>> dataFactory, boolean nullable) {
        super(new JComboBox());
        this.myDataFactory = dataFactory;
        this.myNullable = nullable;
        this.setClickCountToStart(2);
        JComboBox comboBox = (JComboBox)this.editorComponent;
        comboBox.setBorder(null);
        ComboControl.initComboBox(comboBox, new Condition<String>(){

            @Override
            public boolean value(String object) {
                return ComboTableCellEditor.this.myData != null && ComboTableCellEditor.this.myData.containsKey(object) || ComboTableCellEditor.this.myNullable && EMPTY.first == object;
            }
        });
    }

    public ComboTableCellEditor(Class<? extends Enum> anEnum, boolean nullable) {
        this(ComboControl.createEnumFactory(anEnum), nullable);
    }

    @Override
    public Object getCellEditorValue() {
        Pair cellEditorValue = (Pair)super.getCellEditorValue();
        return EMPTY == cellEditorValue || null == cellEditorValue ? null : (String)cellEditorValue.first;
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        List<Pair<String, Icon>> list = this.myDataFactory.create();
        this.myData = new HashMap<String, Icon>();
        JComboBox comboBox = (JComboBox)this.editorComponent;
        comboBox.removeAllItems();
        if (this.myNullable) {
            comboBox.addItem(EMPTY);
        }
        for (Pair<String, Icon> pair : list) {
            this.myData.put((String)pair.first, (Icon)pair.second);
            comboBox.addItem(pair);
        }
        Pair<Object, Icon> pair = Pair.create(value, this.myData.get(value));
        comboBox.setEditable(true);
        super.getTableCellEditorComponent(table, pair, isSelected, row, column);
        comboBox.setEditable(false);
        return comboBox;
    }
}

