/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml.ui;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.GenericDomValue;
import com.intellij.util.xml.reflect.DomFixedChildDescription;
import com.intellij.util.xml.ui.DomColumnInfo;
import com.intellij.util.xml.ui.ErrorableTableCellRenderer;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import org.jetbrains.annotations.NotNull;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChildGenericValueColumnInfo<T extends DomElement>
extends DomColumnInfo<T, String> {
    private final TableCellEditor myEditor;
    private final DomFixedChildDescription myChildDescription;

    public ChildGenericValueColumnInfo(String name, @NotNull DomFixedChildDescription description, TableCellRenderer renderer, TableCellEditor editor) {
        if (description == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/util/xml/ui/ChildGenericValueColumnInfo.<init> must not be null");
        }
        super(name, renderer);
        this.myEditor = editor;
        this.myChildDescription = description;
    }

    public ChildGenericValueColumnInfo(String name, DomFixedChildDescription description, TableCellEditor editor) {
        this(name, description, new DefaultTableCellRenderer(), editor);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ChildGenericValueColumnInfo that = (ChildGenericValueColumnInfo)o;
        return this.myChildDescription.equals(that.myChildDescription);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.myChildDescription.hashCode();
        return result;
    }

    @Override
    public final TableCellEditor getEditor(T value) {
        return this.myEditor;
    }

    @Override
    public final Class<T> getColumnClass() {
        return ReflectionUtil.getRawType(this.myChildDescription.getType());
    }

    @Override
    public TableCellRenderer getCustomizedRenderer(T domElement, TableCellRenderer renderer) {
        assert (domElement.isValid());
        return this.getErrorableCellRenderer(renderer, domElement);
    }

    public DefaultTableCellRenderer getErrorableCellRenderer(TableCellRenderer renderer, T domElement) {
        return new ErrorableTableCellRenderer<GenericDomValue>(this.getGenericValue(domElement), renderer, (DomElement)domElement);
    }

    @Override
    public void setValue(T o, String aValue) {
        this.getGenericValue(o).setStringValue(aValue);
    }

    protected final GenericDomValue getGenericValue(T o) {
        return (GenericDomValue)this.myChildDescription.getValues((DomElement)o).get(0);
    }

    @Override
    public final String valueOf(T object) {
        if (!object.isValid()) {
            return null;
        }
        String stringValue = this.getGenericValue(object).getStringValue();
        return StringUtil.isEmpty(stringValue) ? this.getEmptyValuePresentation(object) : stringValue;
    }

    protected final DomFixedChildDescription getChildDescription() {
        return this.myChildDescription;
    }

    protected String getEmptyValuePresentation(T object) {
        return "";
    }
}

