/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml.tree;

import com.intellij.ide.IdeBundle;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.treeStructure.SimpleNode;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.ElementPresentationManager;
import com.intellij.util.xml.highlighting.DomElementAnnotationsManager;
import com.intellij.util.xml.highlighting.DomElementProblemDescriptor;
import com.intellij.util.xml.highlighting.DomElementsProblemsHolder;
import com.intellij.util.xml.reflect.DomCollectionChildDescription;
import com.intellij.util.xml.tree.AbstractDomElementNode;
import com.intellij.util.xml.tree.BaseDomElementNode;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;

public class DomElementsGroupNode
extends AbstractDomElementNode {
    private DomElement myParentElement;
    private DomElement myRootDomElement;
    private String myChildrenTagName;
    private DomCollectionChildDescription myChildDescription;

    public DomElementsGroupNode(DomElement modelElement, DomCollectionChildDescription description, SimpleNode parent, DomElement rootDomElement) {
        super(modelElement, parent);
        this.myParentElement = modelElement;
        this.myChildDescription = description;
        this.myChildrenTagName = description.getXmlElementName();
        this.myRootDomElement = rootDomElement;
    }

    public SimpleNode[] getChildren() {
        if (!this.myParentElement.isValid()) {
            return NO_CHILDREN;
        }
        ArrayList<BaseDomElementNode> simpleNodes = new ArrayList<BaseDomElementNode>();
        for (DomElement domElement : this.myChildDescription.getStableValues(this.myParentElement)) {
            if (!this.shouldBeShown(domElement.getDomElementType())) continue;
            simpleNodes.add(new BaseDomElementNode(domElement, this.myRootDomElement, this));
        }
        return simpleNodes.toArray(new SimpleNode[simpleNodes.size()]);
    }

    public Object[] getEqualityObjects() {
        return new Object[]{this.myParentElement, this.myChildrenTagName};
    }

    protected void doUpdate() {
        this.setUniformIcon(this.getNodeIcon());
        this.clearColoredText();
        boolean showErrors = this.hasErrors();
        int childrenCount = this.getChildren().length;
        if (childrenCount > 0) {
            SimpleTextAttributes textAttributes = showErrors ? this.getWavedAttributes(1) : new SimpleTextAttributes(1, SimpleTextAttributes.REGULAR_ATTRIBUTES.getFgColor());
            this.addColoredFragment(this.getNodeName(), textAttributes);
            this.addColoredFragment(" (" + childrenCount + ')', showErrors ? IdeBundle.message("dom.elements.tree.childs.contain.errors", new Object[0]) : null, SimpleTextAttributes.GRAY_ITALIC_ATTRIBUTES);
        } else {
            this.addColoredFragment(this.getNodeName(), SimpleTextAttributes.GRAYED_BOLD_ATTRIBUTES);
        }
    }

    private boolean hasErrors() {
        for (DomElement domElement : this.myChildDescription.getStableValues(this.myParentElement)) {
            DomElementAnnotationsManager annotationsManager = DomElementAnnotationsManager.getInstance(this.getProject());
            DomElementsProblemsHolder holder = annotationsManager.getCachedProblemHolder(domElement);
            List<DomElementProblemDescriptor> problems = holder.getProblems(domElement, true, HighlightSeverity.ERROR);
            if (problems.size() <= 0) continue;
            return true;
        }
        return false;
    }

    public String getNodeName() {
        return this.myChildDescription.getCommonPresentableName(this.myParentElement);
    }

    public String getTagName() {
        return this.myChildrenTagName;
    }

    public DomElement getDomElement() {
        return this.myParentElement;
    }

    public DomCollectionChildDescription getChildDescription() {
        return this.myChildDescription;
    }

    public Icon getNodeIcon() {
        Class<?> clazz = ReflectionUtil.getRawType(this.myChildDescription.getType());
        return ElementPresentationManager.getIconForClass(clazz);
    }
}

