/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml.tree;

import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.treeStructure.SimpleNode;
import com.intellij.ui.treeStructure.SimpleTree;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomElementNavigationProvider;
import com.intellij.util.xml.DomElementsNavigationManager;
import com.intellij.util.xml.DomFileElement;
import com.intellij.util.xml.DomUtil;
import com.intellij.util.xml.GenericDomValue;
import com.intellij.util.xml.MergedObject;
import com.intellij.util.xml.StableElement;
import com.intellij.util.xml.highlighting.DomElementAnnotationsManager;
import com.intellij.util.xml.highlighting.DomElementProblemDescriptor;
import com.intellij.util.xml.highlighting.DomElementsProblemsHolder;
import com.intellij.util.xml.reflect.DomCollectionChildDescription;
import com.intellij.util.xml.reflect.DomFixedChildDescription;
import com.intellij.util.xml.tree.AbstractDomElementNode;
import com.intellij.util.xml.tree.DomElementsGroupNode;
import com.intellij.util.xml.tree.GenericValueNode;
import com.intellij.util.xml.ui.TooltipUtils;
import com.intellij.xml.XmlElementDescriptor;
import java.awt.event.InputEvent;
import java.awt.event.MouseEvent;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BaseDomElementNode
extends AbstractDomElementNode {
    public static final Key<Comparator<AbstractDomElementNode>> COMPARATOR_KEY = Key.create("COMPARATOR_KEY");
    public static final Key<List<Class>> CONSOLIDATED_NODES_KEY = Key.create("CONSOLIDATED_NODES_KEY");
    public static final Key<List<Class>> FOLDER_NODES_KEY = Key.create("FOLDER_NODES_KEY");
    private final DomElement myRootDomElement;
    private final DomElement myDomElement;
    private final String myTagName;
    private final boolean folder;

    public BaseDomElementNode(DomElement modelElement) {
        this(modelElement, modelElement, null);
    }

    public BaseDomElementNode(DomElement modelElement, DomElement modelRootElement, SimpleNode parent) {
        super(modelElement, parent);
        this.myDomElement = modelElement;
        this.myRootDomElement = modelRootElement;
        this.myTagName = modelElement.getXmlElementName();
        this.folder = this.isMarkedType(modelElement.getDomElementType(), FOLDER_NODES_KEY);
    }

    @Override
    public SimpleNode[] getChildren() {
        return this.doGetChildren(this.myDomElement);
    }

    @Override
    public void handleDoubleClickOrEnter(SimpleTree tree, InputEvent inputEvent) {
        DomElement domElement;
        if (inputEvent instanceof MouseEvent) {
            inputEvent.consume();
        }
        if ((domElement = this.getDomElement()).isValid()) {
            DomElementNavigationProvider provider = DomElementsNavigationManager.getManager(domElement.getManager().getProject()).getDomElementsNavigateProvider(DomElementsNavigationManager.DEFAULT_PROVIDER_NAME);
            provider.navigate(domElement, true);
        }
    }

    /*
     * WARNING - void declaration
     */
    protected final SimpleNode[] doGetChildren(DomElement element) {
        void var7_12;
        if (!element.isValid()) {
            return NO_CHILDREN;
        }
        ArrayList<AbstractDomElementNode> children = new ArrayList<AbstractDomElementNode>();
        XmlTag tag = element.getXmlTag();
        if (tag != null && !(tag.getContainingFile() instanceof XmlFile)) {
            return NO_CHILDREN;
        }
        XmlElementDescriptor xmlElementDescriptor = tag == null ? null : tag.getDescriptor();
        XmlElementDescriptor[] xmlDescriptors = xmlElementDescriptor == null ? null : xmlElementDescriptor.getElementsDescriptors(tag);
        for (DomFixedChildDescription domFixedChildDescription : element.getGenericInfo().getFixedChildrenDescriptions()) {
            String childName = domFixedChildDescription.getXmlElementName();
            if (xmlDescriptors != null && BaseDomElementNode.findDescriptor(xmlDescriptors, childName) == -1) continue;
            List<? extends DomElement> values = domFixedChildDescription.getStableValues(element);
            if (!this.shouldBeShown(domFixedChildDescription.getType())) continue;
            if (DomUtil.isGenericValueType(domFixedChildDescription.getType())) {
                for (DomElement domElement : values) {
                    children.add(new GenericValueNode((GenericDomValue)domElement, (SimpleNode)this));
                }
                continue;
            }
            for (DomElement domElement : values) {
                children.add(new BaseDomElementNode(domElement, this.myRootDomElement, this));
            }
        }
        for (DomCollectionChildDescription domCollectionChildDescription : element.getGenericInfo().getCollectionChildrenDescriptions()) {
            if (!this.shouldBeShown(domCollectionChildDescription.getType())) continue;
            DomElementsGroupNode groupNode = new DomElementsGroupNode(element, domCollectionChildDescription, this, this.myRootDomElement);
            if (this.isMarkedType(domCollectionChildDescription.getType(), CONSOLIDATED_NODES_KEY)) {
                Collections.addAll(children, groupNode.getChildren());
                continue;
            }
            children.add(groupNode);
        }
        SimpleNode[] childrenNodes = children.toArray(new AbstractDomElementNode[children.size()]);
        Comparator<AbstractDomElementNode> comparator = this.myDomElement.getRoot().getFile().getUserData(COMPARATOR_KEY);
        if (comparator == null) {
            Comparator<AbstractDomElementNode> comparator2 = this.getDefaultComparator(element);
        }
        if (var7_12 != null) {
            Arrays.sort(childrenNodes, var7_12);
        }
        return childrenNodes;
    }

    @Nullable
    protected Comparator<AbstractDomElementNode> getDefaultComparator(DomElement element) {
        XmlElementDescriptor[] childDescriptors;
        XmlElementDescriptor descriptor;
        XmlTag tag = element.getXmlTag();
        if (tag != null && (descriptor = tag.getDescriptor()) != null && (childDescriptors = descriptor.getElementsDescriptors(tag)) != null && childDescriptors.length > 1) {
            return new Comparator<AbstractDomElementNode>(){

                @Override
                public int compare(AbstractDomElementNode o1, AbstractDomElementNode o2) {
                    return BaseDomElementNode.findDescriptor(childDescriptors, o1.getTagName()) - BaseDomElementNode.findDescriptor(childDescriptors, o2.getTagName());
                }
            };
        }
        return null;
    }

    protected static int findDescriptor(XmlElementDescriptor[] descriptors, String name) {
        for (int i = 0; i < descriptors.length; ++i) {
            if (!descriptors[i].getDefaultName().equals(name)) continue;
            return i;
        }
        return -1;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public List<DomCollectionChildDescription> getConsolidatedChildrenDescriptions() {
        List<DomCollectionChildDescription> list;
        if (!this.myDomElement.isValid()) {
            list = Collections.emptyList();
            if (list == null) throw new IllegalStateException("@NotNull method com/intellij/util/xml/tree/BaseDomElementNode.getConsolidatedChildrenDescriptions must not return null");
            return list;
        }
        ArrayList<DomCollectionChildDescription> consolidated = new ArrayList<DomCollectionChildDescription>();
        for (DomCollectionChildDescription domCollectionChildDescription : this.myDomElement.getGenericInfo().getCollectionChildrenDescriptions()) {
            if (!this.isMarkedType(domCollectionChildDescription.getType(), CONSOLIDATED_NODES_KEY)) continue;
            consolidated.add(domCollectionChildDescription);
        }
        list = consolidated;
        if (list != null) return list;
        throw new IllegalStateException("@NotNull method com/intellij/util/xml/tree/BaseDomElementNode.getConsolidatedChildrenDescriptions must not return null");
    }

    @Override
    public Object[] getEqualityObjects() {
        return new Object[]{this.myDomElement};
    }

    @Override
    protected void doUpdate() {
        if (!this.myDomElement.isValid()) {
            return;
        }
        Project project = this.myDomElement.getManager().getProject();
        if (project.isDisposed()) {
            return;
        }
        this.setUniformIcon(this.getNodeIcon());
        this.clearColoredText();
        DomElementAnnotationsManager manager = DomElementAnnotationsManager.getInstance(project);
        DomElementsProblemsHolder holder = manager.getCachedProblemHolder(this.myDomElement);
        List<DomElementProblemDescriptor> problems = holder.getProblems(this.myDomElement, this.highlightIfChildrenHaveProblems(), HighlightSeverity.ERROR);
        if (problems.size() > 0) {
            String toolTip = TooltipUtils.getTooltipText(problems);
            this.addColoredFragment(this.getNodeName(), toolTip, this.getWavedAttributes(0));
            if (this.isShowContainingFileInfo()) {
                this.addColoredFragment(" (" + this.myDomElement.getRoot().getFile().getName() + ")", toolTip, SimpleTextAttributes.GRAY_ATTRIBUTES);
            }
        } else if (this.myDomElement.getXmlTag() == null && !(this.myDomElement instanceof DomFileElement)) {
            this.addColoredFragment(this.getNodeName(), this.folder ? SimpleTextAttributes.GRAYED_BOLD_ATTRIBUTES : SimpleTextAttributes.GRAYED_ATTRIBUTES);
        } else if (this.folder) {
            this.addColoredFragment(this.getNodeName(), SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES);
            int childrenCount = this.getChildren().length;
            this.addColoredFragment(" (" + childrenCount + ')', SimpleTextAttributes.GRAY_ATTRIBUTES);
        } else {
            this.addColoredFragment(this.getNodeName(), SimpleTextAttributes.REGULAR_ATTRIBUTES);
            if (this.isShowContainingFileInfo()) {
                this.addColoredFragment(" (" + this.myDomElement.getRoot().getFile().getName() + ")", SimpleTextAttributes.GRAY_ATTRIBUTES);
            }
        }
    }

    protected boolean isMarkedType(Type type, Key<List<Class>> key) {
        if (type == null) {
            return false;
        }
        List<Class> classes = this.getDomElement().getRoot().getFile().getUserData(key);
        if (classes != null) {
            Class<?> clazz = ReflectionUtil.getRawType(type);
            return classes.contains(clazz);
        }
        return false;
    }

    protected boolean highlightIfChildrenHaveProblems() {
        return true;
    }

    @Override
    public String getNodeName() {
        if (!this.myDomElement.isValid()) {
            return "";
        }
        String name = this.myDomElement.getPresentation().getElementName();
        return name != null && name.trim().length() > 0 ? name : this.getPropertyName();
    }

    @Override
    public String getTagName() {
        return this.myTagName;
    }

    @Override
    public DomElement getDomElement() {
        return this.myDomElement;
    }

    @Override
    public boolean isAutoExpandNode() {
        return this.getParent() == null;
    }

    @Override
    public boolean expandOnDoubleClick() {
        return true;
    }

    public boolean isShowContainingFileInfo() {
        if (!this.myRootDomElement.isValid()) {
            return false;
        }
        DomElement root = this.myRootDomElement;
        while (root instanceof StableElement) {
            root = (DomElement)((StableElement)((Object)root)).getWrappedElement();
        }
        return root instanceof MergedObject && ((MergedObject)((Object)root)).getImplementations().size() > 1;
    }
}

