/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml.model;

import com.intellij.psi.xml.XmlFile;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomFileElement;
import com.intellij.util.xml.DomManager;
import com.intellij.util.xml.ModelMerger;
import java.util.ArrayList;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleDomModelFactory<T extends DomElement> {
    protected final Class<T> myClass;
    protected final ModelMerger myModelMerger;

    public SimpleDomModelFactory(@NotNull Class<T> aClass, @NotNull ModelMerger modelMerger) {
        if (aClass == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/xml/model/SimpleDomModelFactory.<init> must not be null");
        }
        if (modelMerger == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/util/xml/model/SimpleDomModelFactory.<init> must not be null");
        }
        this.myClass = aClass;
        this.myModelMerger = modelMerger;
    }

    @Nullable
    public T getDom(@NotNull XmlFile configFile) {
        if (configFile == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/xml/model/SimpleDomModelFactory.getDom must not be null");
        }
        DomFileElement<T> element = this.getDomRoot(configFile);
        return element == null ? null : (T)element.getRootElement();
    }

    @Nullable
    public DomFileElement<T> getDomRoot(@NotNull XmlFile configFile) {
        if (configFile == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/xml/model/SimpleDomModelFactory.getDomRoot must not be null");
        }
        return DomManager.getDomManager(configFile.getProject()).getFileElement(configFile, this.myClass);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Deprecated
    @NotNull
    public T createMergedModel(Set<XmlFile> configFiles) {
        T t = this.createMergedModelRoot(configFiles).getRootElement();
        if (t == null) {
            throw new IllegalStateException("@NotNull method com/intellij/util/xml/model/SimpleDomModelFactory.createMergedModel must not return null");
        }
        return t;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public DomFileElement<T> createMergedModelRoot(Set<XmlFile> configFiles) {
        ArrayList configs = new ArrayList(configFiles.size());
        for (XmlFile configFile : configFiles) {
            ContainerUtil.addIfNotNull(this.getDomRoot(configFile), configs);
        }
        DomFileElement domFileElement = this.myModelMerger.mergeModels(DomFileElement.class, configs);
        if (domFileElement == null) {
            throw new IllegalStateException("@NotNull method com/intellij/util/xml/model/SimpleDomModelFactory.createMergedModelRoot must not return null");
        }
        return domFileElement;
    }
}

