/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml.model;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.xml.XmlFile;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomFileElement;
import com.intellij.util.xml.DomManager;
import com.intellij.util.xml.ModelMerger;
import com.intellij.util.xml.model.DomModel;
import com.intellij.util.xml.model.DomModelCache;
import com.intellij.util.xml.model.SimpleDomModelFactory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DomModelFactory<T extends DomElement, M extends DomModel<T>, C extends PsiElement>
extends SimpleDomModelFactory<T> {
    private final DomModelCache<M, XmlFile> myModelCache;
    private final DomModelCache<M, Module> myCombinedModelCache;
    private final DomModelCache<List<M>, Module> myAllModelsCache;

    protected DomModelFactory(@NotNull Class<T> aClass, @NotNull ModelMerger modelMerger, Project project, @NonNls String name) {
        if (aClass == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/xml/model/DomModelFactory.<init> must not be null");
        }
        if (modelMerger == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/util/xml/model/DomModelFactory.<init> must not be null");
        }
        super(aClass, modelMerger);
        this.myModelCache = new DomModelCache<M, XmlFile>(project, name + " model"){

            /*
             * Enabled aggressive block sorting
             */
            @Override
            @NotNull
            protected CachedValueProvider.Result<M> computeValue(@NotNull XmlFile file) {
                if (file == null) {
                    throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/xml/model/DomModelFactory$1.computeValue must not be null");
                }
                PsiFile originalFile = file.getOriginalFile();
                if (originalFile != null) {
                    file = (XmlFile)originalFile;
                }
                Module module = ModuleUtil.findModuleForPsiElement(file);
                Object model = DomModelFactory.this.computeModel(file, module);
                CachedValueProvider.Result result = new CachedValueProvider.Result(model, DomModelFactory.this.computeDependencies(model, module));
                if (result == null) {
                    throw new IllegalStateException("@NotNull method com/intellij/util/xml/model/DomModelFactory$1.computeValue must not return null");
                }
                return result;
            }
        };
        this.myCombinedModelCache = new DomModelCache<M, Module>(project, name + " combined model"){

            /*
             * Enabled aggressive block sorting
             */
            @Override
            @NotNull
            protected CachedValueProvider.Result<M> computeValue(@NotNull Module module) {
                if (module == null) {
                    throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/xml/model/DomModelFactory$2.computeValue must not be null");
                }
                Object combinedModel = DomModelFactory.this.computeCombinedModel(module);
                CachedValueProvider.Result result = new CachedValueProvider.Result(combinedModel, DomModelFactory.this.computeDependencies(combinedModel, module));
                if (result == null) {
                    throw new IllegalStateException("@NotNull method com/intellij/util/xml/model/DomModelFactory$2.computeValue must not return null");
                }
                return result;
            }
        };
        this.myAllModelsCache = new DomModelCache<List<M>, Module>(project, name + " models list"){

            /*
             * Enabled aggressive block sorting
             */
            @Override
            @NotNull
            protected CachedValueProvider.Result<List<M>> computeValue(@NotNull Module module) {
                if (module == null) {
                    throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/xml/model/DomModelFactory$3.computeValue must not be null");
                }
                List models = DomModelFactory.this.computeAllModels(module);
                CachedValueProvider.Result result = new CachedValueProvider.Result(models, DomModelFactory.this.computeDependencies(null, module));
                if (result == null) {
                    throw new IllegalStateException("@NotNull method com/intellij/util/xml/model/DomModelFactory$3.computeValue must not return null");
                }
                return result;
            }
        };
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public Object[] computeDependencies(@Nullable M model, @Nullable Module module) {
        ArrayList<Object> dependencies = new ArrayList<Object>();
        if (model != null) {
            Set<XmlFile> files = model.getConfigFiles();
            dependencies.addAll(files);
        } else {
            dependencies.add(PsiModificationTracker.OUT_OF_CODE_BLOCK_MODIFICATION_COUNT);
        }
        if (module != null) {
            dependencies.add(ProjectRootManager.getInstance(module.getProject()));
        }
        Object[] objectArray = dependencies.toArray(new Object[dependencies.size()]);
        if (objectArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/util/xml/model/DomModelFactory.computeDependencies must not return null");
        }
        return objectArray;
    }

    @Nullable
    public abstract M getModel(@NotNull C var1);

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public List<M> getAllModels(@NotNull Module module) {
        List<Object> list;
        if (module == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/xml/model/DomModelFactory.getAllModels must not be null");
        }
        List<M> models = this.myAllModelsCache.getCachedValue(module);
        if (models == null) {
            list = Collections.emptyList();
            if (list == null) throw new IllegalStateException("@NotNull method com/intellij/util/xml/model/DomModelFactory.getAllModels must not return null");
            return list;
        }
        list = models;
        if (list != null) return list;
        throw new IllegalStateException("@NotNull method com/intellij/util/xml/model/DomModelFactory.getAllModels must not return null");
    }

    @Nullable
    protected abstract List<M> computeAllModels(@NotNull Module var1);

    @Nullable
    public M getModelByConfigFile(@Nullable XmlFile psiFile) {
        if (psiFile == null) {
            return null;
        }
        return (M)((DomModel)this.myModelCache.getCachedValue(psiFile));
    }

    @Nullable
    protected M computeModel(@NotNull XmlFile psiFile, @Nullable Module module) {
        if (psiFile == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/xml/model/DomModelFactory.computeModel must not be null");
        }
        if (module == null) {
            return null;
        }
        List<M> models = this.getAllModels(module);
        for (DomModel model : models) {
            Set<XmlFile> configFiles = model.getConfigFiles();
            if (!configFiles.contains(psiFile)) continue;
            return (M)model;
        }
        return null;
    }

    @Nullable
    public M getCombinedModel(@Nullable Module module) {
        if (module == null) {
            return null;
        }
        return (M)((DomModel)this.myCombinedModelCache.getCachedValue(module));
    }

    @Nullable
    protected M computeCombinedModel(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/xml/model/DomModelFactory.computeCombinedModel must not be null");
        }
        List<M> models = this.getAllModels(module);
        switch (models.size()) {
            case 0: {
                return null;
            }
            case 1: {
                return (M)((DomModel)models.get(0));
            }
        }
        LinkedHashSet<XmlFile> configFiles = new LinkedHashSet<XmlFile>();
        LinkedHashSet list = new LinkedHashSet(models.size());
        for (DomModel model : models) {
            Set<XmlFile> files = model.getConfigFiles();
            for (XmlFile file : files) {
                ContainerUtil.addIfNotNull(this.getDomRoot(file), list);
            }
            configFiles.addAll(files);
        }
        DomFileElement mergedModel = this.getModelMerger().mergeModels(DomFileElement.class, list);
        DomModel firstModel = (DomModel)models.get(0);
        return (M)this.createCombinedModel(configFiles, mergedModel, firstModel, module);
    }

    protected abstract M createCombinedModel(Set<XmlFile> var1, DomFileElement<T> var2, M var3, Module var4);

    @NotNull
    public Set<XmlFile> getConfigFiles(@Nullable C context) {
        M model;
        Set<XmlFile> set;
        if (!(context == null ? (set = Collections.emptySet()) != null : ((model = this.getModel(context)) == null ? (set = Collections.emptySet()) != null : (set = model.getConfigFiles()) != null))) {
            throw new IllegalStateException("@NotNull method com/intellij/util/xml/model/DomModelFactory.getConfigFiles must not return null");
        }
        return set;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public Set<XmlFile> getAllConfigFiles(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/xml/model/DomModelFactory.getAllConfigFiles must not be null");
        }
        HashSet<XmlFile> xmlFiles = new HashSet<XmlFile>();
        for (DomModel model : this.getAllModels(module)) {
            xmlFiles.addAll(model.getConfigFiles());
        }
        HashSet<XmlFile> hashSet = xmlFiles;
        if (hashSet == null) {
            throw new IllegalStateException("@NotNull method com/intellij/util/xml/model/DomModelFactory.getAllConfigFiles must not return null");
        }
        return hashSet;
    }

    public List<DomFileElement<T>> getFileElements(M model) {
        ArrayList<DomFileElement<T>> list = new ArrayList<DomFileElement<T>>(model.getConfigFiles().size());
        for (XmlFile configFile : model.getConfigFiles()) {
            DomFileElement element = DomManager.getDomManager(configFile.getProject()).getFileElement(configFile, this.myClass);
            if (element == null) continue;
            list.add(element);
        }
        return list;
    }

    public ModelMerger getModelMerger() {
        return this.myModelMerger;
    }

    public Class<T> getClazz() {
        return this.myClass;
    }
}

