/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml.model;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.psi.PsiManager;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DomModelCache<T, H extends UserDataHolder> {
    private final Key<CachedValue<T>> myKey;
    private final Project myProject;

    public DomModelCache(Project project, @NonNls String keyName) {
        this.myProject = project;
        this.myKey = new Key(keyName);
    }

    @Nullable
    public T getCachedValue(@NotNull H dataHolder) {
        if (dataHolder == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/xml/model/DomModelCache.getCachedValue must not be null");
        }
        CachedValue<T> cachedValue = dataHolder.getUserData(this.myKey);
        if (cachedValue == null) {
            CachedValueProvider myProvider = new CachedValueProvider<T>((UserDataHolder)dataHolder){
                final /* synthetic */ UserDataHolder val$dataHolder;
                {
                    this.val$dataHolder = userDataHolder;
                }

                @Override
                @Nullable
                public CachedValueProvider.Result<T> compute() {
                    return DomModelCache.this.computeValue(this.val$dataHolder);
                }
            };
            CachedValuesManager manager = PsiManager.getInstance(this.myProject).getCachedValuesManager();
            cachedValue = manager.createCachedValue(myProvider, false);
            dataHolder.putUserData(this.myKey, cachedValue);
        }
        return cachedValue.getValue();
    }

    @NotNull
    protected abstract CachedValueProvider.Result<T> computeValue(@NotNull H var1);
}

