/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml.highlighting;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.xml.DomBundle;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomManager;
import com.intellij.util.xml.GenericAttributeValue;
import org.jetbrains.annotations.NotNull;

public class RemoveDomElementQuickFix
implements LocalQuickFix {
    private final boolean myIsTag;
    private final String myName;

    public RemoveDomElementQuickFix(@NotNull DomElement element) {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/xml/highlighting/RemoveDomElementQuickFix.<init> must not be null");
        }
        this.myIsTag = element.getXmlElement() instanceof XmlTag;
        this.myName = element.getXmlElementName();
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public String getName() {
        String string = this.myIsTag ? DomBundle.message("remove.element.fix.name", this.myName) : DomBundle.message("remove.attribute.fix.name", this.myName);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/util/xml/highlighting/RemoveDomElementQuickFix.getName must not return null");
        }
        return string;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public String getFamilyName() {
        String string = DomBundle.message("quick.fixes.family", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/util/xml/highlighting/RemoveDomElementQuickFix.getFamilyName must not return null");
        }
        return string;
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/xml/highlighting/RemoveDomElementQuickFix.applyFix must not be null");
        }
        if (descriptor == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/util/xml/highlighting/RemoveDomElementQuickFix.applyFix must not be null");
        }
        if (this.myIsTag) {
            XmlTag tag = (XmlTag)descriptor.getPsiElement();
            XmlTag parentTag = tag.getParentTag();
            DomElement domElement = DomManager.getDomManager(project).getDomElement(tag);
            assert (domElement != null);
            domElement.undefine();
            if (parentTag != null && parentTag.isValid()) {
                parentTag.collapseIfEmpty();
            }
        } else {
            GenericAttributeValue domElement = DomManager.getDomManager(project).getDomElement((XmlAttribute)descriptor.getPsiElement());
            assert (domElement != null);
            domElement.undefine();
        }
    }
}

