/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml.highlighting;

import com.intellij.util.ReflectionUtil;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.GenericAttributeValue;
import com.intellij.util.xml.GenericDomValue;
import com.intellij.util.xml.highlighting.DomElementAnnotationHolder;
import com.intellij.util.xml.highlighting.DomElementsInspection;
import com.intellij.util.xml.highlighting.DomHighlightingHelper;
import org.jetbrains.annotations.NotNull;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BasicDomElementsInspection<T extends DomElement>
extends DomElementsInspection<T> {
    public BasicDomElementsInspection(@NotNull Class<? extends T> domClass, Class<? extends T> ... additionalClasses) {
        if (domClass == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/xml/highlighting/BasicDomElementsInspection.<init> must not be null");
        }
        super(domClass, additionalClasses);
    }

    protected boolean shouldCheckResolveProblems(GenericDomValue value) {
        return true;
    }

    @Override
    protected void checkDomElement(DomElement element, DomElementAnnotationHolder holder, DomHighlightingHelper helper) {
        GenericDomValue genericDomValue;
        int oldSize = holder.getSize();
        if (element instanceof GenericDomValue && this.shouldCheckResolveProblems(genericDomValue = (GenericDomValue)element)) {
            helper.checkResolveProblems(genericDomValue, holder);
        }
        for (Class aClass : this.getDomClasses()) {
            helper.runAnnotators(element, holder, aClass);
        }
        if (oldSize != holder.getSize()) {
            return;
        }
        if (!helper.checkRequired(element, holder).isEmpty()) {
            return;
        }
        if (element instanceof GenericDomValue) {
            helper.checkExtendClass((GenericDomValue)element, holder);
        }
        if (!(element instanceof GenericAttributeValue) && !GenericDomValue.class.equals(ReflectionUtil.getRawType(element.getDomElementType()))) {
            helper.checkNameIdentity(element, holder);
        }
    }
}

