/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml.converters;

import com.intellij.codeInsight.daemon.EmptyResolveMessageProvider;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.ElementManipulator;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiPolyVariantReferenceBase;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveResult;
import com.intellij.util.xml.ConvertContext;
import com.intellij.util.xml.CustomReferenceConverter;
import com.intellij.util.xml.DomBundle;
import com.intellij.util.xml.GenericDomValue;
import com.intellij.util.xml.ResolvingConverter;
import com.intellij.xml.util.XmlTagTextUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class QuotedValueConverter<T>
extends ResolvingConverter<T>
implements CustomReferenceConverter<T> {
    public static final char[] QUOTE_SIGNS = new char[]{'\'', '\"', '`'};

    protected char[] getQuoteSigns() {
        return QUOTE_SIGNS;
    }

    protected char getQuoteSign(T t, ConvertContext context) {
        return '\u0000';
    }

    @Nullable
    protected abstract T convertString(@Nullable String var1, ConvertContext var2);

    @Nullable
    protected abstract String convertValue(@Nullable T var1, ConvertContext var2);

    protected abstract Object[] getReferenceVariants(ConvertContext var1, GenericDomValue<T> var2, TextRange var3);

    @NotNull
    protected abstract ResolveResult[] multiResolveReference(@Nullable T var1, ConvertContext var2);

    protected abstract String getUnresolvedMessage(String var1);

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @NotNull
    public Collection<? extends T> getVariants(ConvertContext context) {
        List list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException("@NotNull method com/intellij/util/xml/converters/QuotedValueConverter.getVariants must not return null");
        }
        return list;
    }

    @Override
    public T fromString(String str, ConvertContext context) {
        return this.convertString(QuotedValueConverter.unquote(str, this.getQuoteSigns()), context);
    }

    @Override
    public String toString(T ts, ConvertContext context) {
        char delimiter = this.getQuoteSign(ts, context);
        String s = this.convertValue(ts, context);
        return delimiter > '\u0000' ? delimiter + s + delimiter : s;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @NotNull
    public PsiReference[] createReferences(GenericDomValue<T> genericDomValue, PsiElement element, ConvertContext context) {
        PsiReference[] psiReferenceArray;
        String originalValue = genericDomValue.getStringValue();
        if (originalValue == null) {
            psiReferenceArray = PsiReference.EMPTY_ARRAY;
            if (PsiReference.EMPTY_ARRAY == null) throw new IllegalStateException("@NotNull method com/intellij/util/xml/converters/QuotedValueConverter.createReferences must not return null");
            return psiReferenceArray;
        }
        String unquotedValue = QuotedValueConverter.unquote(originalValue, this.getQuoteSigns());
        int startOffset = originalValue == unquotedValue ? 0 : XmlTagTextUtil.escapeString(originalValue.substring(0, 1), false).length();
        int endOffset = originalValue == unquotedValue || QuotedValueConverter.quotationIsNotClosed(originalValue) ? 0 : startOffset;
        ElementManipulator<PsiElement> manipulator = context.getPsiManager().getElementManipulatorsRegistry().getManipulator(element);
        assert (manipulator != null) : "manipulator not found";
        TextRange range = manipulator.getRangeInElement(element);
        psiReferenceArray = new PsiReference[]{this.createPsiReference(element, range.getStartOffset() + startOffset, range.getEndOffset() - endOffset, true, context, genericDomValue, startOffset != endOffset)};
        if (psiReferenceArray != null) return psiReferenceArray;
        throw new IllegalStateException("@NotNull method com/intellij/util/xml/converters/QuotedValueConverter.createReferences must not return null");
    }

    @Nullable
    public static String unquote(String str) {
        return QuotedValueConverter.unquote(str, QUOTE_SIGNS);
    }

    @Nullable
    public static String unquote(String str, char[] quoteSigns) {
        if (str != null && str.length() > 2) {
            char c = str.charAt(0);
            for (char quote : quoteSigns) {
                if (quote != c) continue;
                return str.substring(1, c == str.charAt(str.length() - 1) ? str.length() - 1 : str.length());
            }
        }
        return str;
    }

    public static boolean quotationIsNotClosed(String str) {
        return StringUtil.isNotEmpty(str) && str.charAt(0) != str.charAt(str.length() - 1);
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    protected PsiReference createPsiReference(PsiElement element, int start, int end, boolean isSoft, ConvertContext context, GenericDomValue<T> genericDomValue, boolean badQuotation) {
        MyPsiReference myPsiReference = new MyPsiReference(element, new TextRange(start, end), isSoft, context, genericDomValue, badQuotation);
        if (myPsiReference == null) {
            throw new IllegalStateException("@NotNull method com/intellij/util/xml/converters/QuotedValueConverter.createPsiReference must not return null");
        }
        return myPsiReference;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class MyPsiReference
    extends PsiPolyVariantReferenceBase<PsiElement>
    implements EmptyResolveMessageProvider {
        protected final ConvertContext myContext;
        protected final GenericDomValue<T> myGenericDomValue;
        private final boolean myBadQuotation;

        public MyPsiReference(PsiElement element, TextRange range, boolean isSoft, ConvertContext context, GenericDomValue<T> genericDomValue, boolean badQuotation) {
            super(element, range, isSoft);
            this.myContext = context;
            this.myGenericDomValue = genericDomValue;
            this.myBadQuotation = badQuotation;
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        @NotNull
        public ResolveResult[] multiResolve(boolean incompleteCode) {
            ResolveResult[] resolveResultArray;
            if (this.myBadQuotation) {
                resolveResultArray = ResolveResult.EMPTY_ARRAY;
                if (ResolveResult.EMPTY_ARRAY == null) throw new IllegalStateException("@NotNull method com/intellij/util/xml/converters/QuotedValueConverter$MyPsiReference.multiResolve must not return null");
                return resolveResultArray;
            }
            String value = this.getValue();
            resolveResultArray = QuotedValueConverter.this.multiResolveReference(QuotedValueConverter.this.convertString(value, this.myContext), this.myContext);
            if (resolveResultArray != null) return resolveResultArray;
            throw new IllegalStateException("@NotNull method com/intellij/util/xml/converters/QuotedValueConverter$MyPsiReference.multiResolve must not return null");
        }

        @Override
        public Object[] getVariants() {
            return QuotedValueConverter.this.getReferenceVariants(this.myContext, this.myGenericDomValue, this.getRangeInElement());
        }

        @Override
        public String getUnresolvedMessagePattern() {
            return this.myBadQuotation ? DomBundle.message("message.invalid.value.quotation", new Object[0]) : QuotedValueConverter.this.getUnresolvedMessage(this.getValue());
        }
    }
}

