/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml.converters;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.paths.PathReference;
import com.intellij.openapi.paths.PathReferenceManager;
import com.intellij.openapi.paths.PathReferenceProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.xml.XmlElement;
import com.intellij.util.xml.ConvertContext;
import com.intellij.util.xml.Converter;
import com.intellij.util.xml.CustomReferenceConverter;
import com.intellij.util.xml.GenericDomValue;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PathReferenceConverter
extends Converter<PathReference>
implements CustomReferenceConverter {
    public static final Converter<PathReference> INSTANCE = new PathReferenceConverter();

    @Override
    public PathReference fromString(@Nullable String s, ConvertContext context) {
        Module module = context.getModule();
        XmlElement element = context.getXmlElement();
        return s == null || module == null || element == null ? null : PathReferenceManager.getInstance().getPathReference(s, module, element, new PathReferenceProvider[0]);
    }

    @Override
    public String toString(PathReference t, ConvertContext context) {
        return t == null ? null : t.getPath();
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public PsiReference[] createReferences(GenericDomValue genericDomValue, PsiElement element, ConvertContext context) {
        PsiReference[] psiReferenceArray = this.createReferences(element, true);
        if (psiReferenceArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/util/xml/converters/PathReferenceConverter.createReferences must not return null");
        }
        return psiReferenceArray;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public PsiReference[] createReferences(@NotNull PsiElement psiElement, boolean soft) {
        if (psiElement == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/xml/converters/PathReferenceConverter.createReferences must not be null");
        }
        PsiReference[] psiReferenceArray = PathReferenceManager.getInstance().createReferences(psiElement, soft, new PathReferenceProvider[0]);
        if (psiReferenceArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/util/xml/converters/PathReferenceConverter.createReferences must not return null");
        }
        return psiReferenceArray;
    }
}

