/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml.converters;

import com.intellij.codeInsight.daemon.EmptyResolveMessageProvider;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceBase;
import com.intellij.util.xml.ConvertContext;
import com.intellij.util.xml.CustomReferenceConverter;
import com.intellij.util.xml.GenericDomValue;
import com.intellij.util.xml.ResolvingConverter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DelimitedListConverter<T>
extends ResolvingConverter<List<T>>
implements CustomReferenceConverter<List<T>> {
    protected static final Object[] EMPTY_ARRAY = new Object[0];
    private final String myDelimiters;

    public DelimitedListConverter(@NonNls @NotNull String delimiters) {
        if (delimiters == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/xml/converters/DelimitedListConverter.<init> must not be null");
        }
        this.myDelimiters = delimiters;
    }

    @Nullable
    protected abstract T convertString(@Nullable String var1, ConvertContext var2);

    @Nullable
    protected abstract String toString(@Nullable T var1);

    protected abstract Object[] getReferenceVariants(ConvertContext var1, GenericDomValue<List<T>> var2);

    @Nullable
    protected abstract PsiElement resolveReference(@Nullable T var1, ConvertContext var2);

    protected abstract String getUnresolvedMessage(String var1);

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @NotNull
    public Collection<? extends List<T>> getVariants(ConvertContext context) {
        List list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException("@NotNull method com/intellij/util/xml/converters/DelimitedListConverter.getVariants must not return null");
        }
        return list;
    }

    public static <T> void filterVariants(List<T> variants, GenericDomValue<List<T>> genericDomValue) {
        List list = (List)genericDomValue.getValue();
        if (list != null) {
            Iterator<T> i = variants.iterator();
            block0: while (i.hasNext()) {
                T variant = i.next();
                for (Object existing : list) {
                    if (!existing.equals(variant)) continue;
                    i.remove();
                    continue block0;
                }
            }
        }
    }

    protected char getDefaultDelimiter() {
        return this.myDelimiters.charAt(0);
    }

    @Override
    public List<T> fromString(@Nullable String str, ConvertContext context) {
        if (str == null) {
            return null;
        }
        ArrayList<T> values = new ArrayList<T>();
        for (String s : StringUtil.tokenize(str, this.myDelimiters)) {
            T t = this.convertString(s.trim(), context);
            if (t == null) continue;
            values.add(t);
        }
        return values;
    }

    @Override
    public String toString(List<T> ts, ConvertContext context) {
        StringBuffer buffer = new StringBuffer();
        char delimiter = this.getDefaultDelimiter();
        for (T t : ts) {
            String s = this.toString(t);
            if (s == null) continue;
            if (buffer.length() != 0) {
                buffer.append(delimiter);
            }
            buffer.append(s);
        }
        return buffer.toString();
    }

    protected int skipDelimiters(String s, int pos) {
        char ch;
        while (pos < s.length() && this.isDelimiter(ch = s.charAt(pos))) {
            ++pos;
        }
        return pos;
    }

    protected boolean isDelimiter(char ch) {
        return ch <= ' ' || this.myDelimiters.indexOf(ch) != -1;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @NotNull
    public PsiReference[] createReferences(GenericDomValue<List<T>> genericDomValue, PsiElement element, ConvertContext context) {
        PsiReference[] psiReferenceArray;
        String text = genericDomValue.getStringValue();
        if (text == null) {
            psiReferenceArray = PsiReference.EMPTY_ARRAY;
            if (PsiReference.EMPTY_ARRAY == null) throw new IllegalStateException("@NotNull method com/intellij/util/xml/converters/DelimitedListConverter.createReferences must not return null");
            return psiReferenceArray;
        }
        boolean shift = true;
        int pos = 0;
        ArrayList<PsiReference> references = new ArrayList<PsiReference>();
        do {
            int start = pos;
            if ((pos = this.skipDelimiters(text, pos)) == text.length()) {
                if (references.size() != 0) break;
                references.add(this.createPsiReference(element, start + 1, pos + 1, context, genericDomValue));
                break;
            }
            start = pos;
            while (++pos < text.length() && !this.isDelimiter(text.charAt(pos))) {
            }
            references.add(this.createPsiReference(element, start + 1, pos + 1, context, genericDomValue));
        } while (++pos < text.length());
        if ((psiReferenceArray = references.toArray(new PsiReference[references.size()])) != null) return psiReferenceArray;
        throw new IllegalStateException("@NotNull method com/intellij/util/xml/converters/DelimitedListConverter.createReferences must not return null");
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    protected PsiReference createPsiReference(PsiElement element, int start, int end, ConvertContext context, GenericDomValue<List<T>> genericDomValue) {
        MyPsiReference myPsiReference = new MyPsiReference(element, new TextRange(start, end), context, genericDomValue);
        if (myPsiReference == null) {
            throw new IllegalStateException("@NotNull method com/intellij/util/xml/converters/DelimitedListConverter.createPsiReference must not return null");
        }
        return myPsiReference;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class MyPsiReference
    extends PsiReferenceBase<PsiElement>
    implements EmptyResolveMessageProvider {
        protected final ConvertContext myContext;
        protected final GenericDomValue<List<T>> myGenericDomValue;

        public MyPsiReference(PsiElement element, TextRange range, ConvertContext context, GenericDomValue<List<T>> genericDomValue) {
            this(element, range, context, genericDomValue, true);
        }

        public MyPsiReference(PsiElement element, TextRange range, ConvertContext context, GenericDomValue<List<T>> genericDomValue, boolean soft) {
            super(element, range, soft);
            this.myContext = context;
            this.myGenericDomValue = genericDomValue;
        }

        @Override
        @Nullable
        public PsiElement resolve() {
            String value = this.getValue();
            return DelimitedListConverter.this.resolveReference(DelimitedListConverter.this.convertString(value, this.myContext), this.myContext);
        }

        @Override
        public Object[] getVariants() {
            return DelimitedListConverter.this.getReferenceVariants(this.myContext, this.myGenericDomValue);
        }

        @Override
        public String getUnresolvedMessagePattern() {
            return DelimitedListConverter.this.getUnresolvedMessage(this.getValue());
        }
    }
}

