/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml.converters;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.QuickFixFactory;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PropertyMemberType;
import com.intellij.psi.util.PropertyUtil;
import com.intellij.util.xml.ConvertContext;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.ElementPresentationManager;
import com.intellij.util.xml.GenericDomValue;
import com.intellij.util.xml.GenericValue;
import com.intellij.util.xml.ResolvingConverter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractMemberResolveConverter
extends ResolvingConverter<PsiMember> {
    @Nullable
    protected abstract PsiClass getTargetClass(ConvertContext var1);

    @NotNull
    protected abstract PropertyMemberType[] getMemberTypes(ConvertContext var1);

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    protected PsiType getPsiType(ConvertContext context) {
        PsiClassType psiClassType = PsiType.getJavaLangObject(context.getPsiManager(), context.getPsiManager().getProject().getAllScope());
        if (psiClassType == null) {
            throw new IllegalStateException("@NotNull method com/intellij/util/xml/converters/AbstractMemberResolveConverter.getPsiType must not return null");
        }
        return psiClassType;
    }

    protected boolean isLookDeep() {
        return true;
    }

    protected boolean isPropertyNameUsed() {
        return true;
    }

    @Override
    public PsiMember fromString(String s, ConvertContext context) {
        if (s == null) {
            return null;
        }
        PsiClass psiClass = this.getTargetClass(context);
        if (psiClass == null) {
            return null;
        }
        String propertyName = this.isPropertyNameUsed() ? s : PropertyUtil.getPropertyName(s);
        block5: for (PropertyMemberType type : this.getMemberTypes(context)) {
            switch (type) {
                case FIELD: {
                    PsiField field = psiClass.findFieldByName(propertyName, this.isLookDeep());
                    if (field == null) continue block5;
                    return field;
                }
                case GETTER: {
                    PsiMethod getter = PropertyUtil.findPropertyGetter(psiClass, propertyName, false, this.isLookDeep());
                    if (getter == null) continue block5;
                    return getter;
                }
                case SETTER: {
                    PsiMethod setter = PropertyUtil.findPropertySetter(psiClass, propertyName, false, this.isLookDeep());
                    if (setter == null) continue block5;
                    return setter;
                }
            }
        }
        return null;
    }

    @Override
    public String toString(PsiMember t, ConvertContext context) {
        return t == null ? null : (this.isPropertyNameUsed() ? PropertyUtil.getPropertyName(t) : t.getName());
    }

    @Override
    public String getErrorMessage(String s, ConvertContext context) {
        DomElement parent = context.getInvocationElement().getParent();
        assert (parent != null);
        return CodeInsightBundle.message("error.cannot.resolve.0.1", ElementPresentationManager.getTypeName(parent.getClass()), s);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @NotNull
    public Collection<? extends PsiMember> getVariants(ConvertContext context) {
        List list;
        PsiClass psiClass = this.getTargetClass(context);
        if (psiClass == null) {
            list = Collections.emptyList();
            if (list == null) throw new IllegalStateException("@NotNull method com/intellij/util/xml/converters/AbstractMemberResolveConverter.getVariants must not return null");
            return list;
        }
        ArrayList list2 = new ArrayList();
        for (PsiField psiField : this.isLookDeep() ? psiClass.getAllFields() : psiClass.getFields()) {
            if (!this.fieldSuits(psiField)) continue;
            list2.add(psiField);
        }
        for (PsiNamedElement psiNamedElement : this.isLookDeep() ? psiClass.getAllMethods() : psiClass.getMethods()) {
            if (!this.methodSuits((PsiMethod)psiNamedElement)) continue;
            list2.add(psiNamedElement);
        }
        list = list2;
        if (list != null) return list;
        throw new IllegalStateException("@NotNull method com/intellij/util/xml/converters/AbstractMemberResolveConverter.getVariants must not return null");
    }

    protected boolean methodSuits(PsiMethod psiMethod) {
        return !psiMethod.isConstructor() && !psiMethod.hasModifierProperty("static") && PropertyUtil.getPropertyName(psiMethod) != null;
    }

    protected boolean fieldSuits(PsiField psiField) {
        return !psiField.hasModifierProperty("static");
    }

    @Override
    public LocalQuickFix[] getQuickFixes(ConvertContext context) {
        LocalQuickFix[] localQuickFixArray;
        String targetName = ((GenericValue)((Object)context.getInvocationElement())).getStringValue();
        if (targetName == null) {
            return super.getQuickFixes(context);
        }
        PsiClass targetClass = this.getTargetClass(context);
        if (targetClass == null) {
            return super.getQuickFixes(context);
        }
        PropertyMemberType memberType = this.getMemberTypes(context)[0];
        PsiType psiType = this.getPsiType(context);
        IntentionAction fix = QuickFixFactory.getInstance().createCreateFieldOrPropertyFix(targetClass, targetName, psiType, memberType, new PsiAnnotation[0]);
        if (fix instanceof LocalQuickFix) {
            LocalQuickFix[] localQuickFixArray2 = new LocalQuickFix[1];
            localQuickFixArray = localQuickFixArray2;
            localQuickFixArray2[0] = (LocalQuickFix)((Object)fix);
        } else {
            localQuickFixArray = super.getQuickFixes(context);
        }
        return localQuickFixArray;
    }

    @Override
    public void handleElementRename(GenericDomValue<PsiMember> genericValue, ConvertContext context, String newElementName) {
        super.handleElementRename(genericValue, context, this.isPropertyNameUsed() ? PropertyUtil.getPropertyName(newElementName) : newElementName);
    }

    @Override
    public void bindReference(GenericDomValue<PsiMember> genericValue, ConvertContext context, PsiElement newTarget) {
        if (newTarget instanceof PsiMember) {
            String elementName = ((PsiMember)newTarget).getName();
            genericValue.setStringValue(this.isPropertyNameUsed() ? PropertyUtil.getPropertyName(elementName) : elementName);
        }
    }
}

