/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml;

import com.intellij.openapi.util.Comparing;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XmlName
implements Comparable<XmlName> {
    private final String myLocalName;
    private final String myNamespaceKey;

    public XmlName(@NotNull @NonNls String localName) {
        if (localName == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/xml/XmlName.<init> must not be null");
        }
        this(localName, null);
    }

    public XmlName(@NotNull @NonNls String localName, @Nullable String namespaceKey) {
        if (localName == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/xml/XmlName.<init> must not be null");
        }
        this.myLocalName = localName;
        this.myNamespaceKey = namespaceKey;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public final String getLocalName() {
        String string = this.myLocalName;
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/util/xml/XmlName.getLocalName must not return null");
        }
        return string;
    }

    @Nullable
    public final String getNamespaceKey() {
        return this.myNamespaceKey;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        XmlName xmlName = (XmlName)o;
        if (!this.myLocalName.equals(xmlName.myLocalName)) {
            return false;
        }
        if (Comparing.equal(this.myNamespaceKey, xmlName.myNamespaceKey)) {
            return true;
        }
        return !(this.myNamespaceKey != null ? !this.myNamespaceKey.equals(xmlName.myNamespaceKey) : xmlName.myNamespaceKey != null);
    }

    public int hashCode() {
        int result = this.myLocalName.hashCode();
        result = 31 * result + (this.myNamespaceKey != null ? this.myNamespaceKey.hashCode() : 0);
        return result;
    }

    @Override
    public int compareTo(XmlName o) {
        int i = this.myLocalName.compareTo(o.myLocalName);
        if (i != 0) {
            return i;
        }
        if (Comparing.equal(this.myNamespaceKey, o.myNamespaceKey)) {
            return 0;
        }
        if (this.myNamespaceKey == null) {
            return -1;
        }
        if (o.myNamespaceKey == null) {
            return 1;
        }
        return this.myNamespaceKey.compareTo(o.myNamespaceKey);
    }

    public String toString() {
        return this.myNamespaceKey + " : " + this.myLocalName;
    }
}

