/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiPackage;
import com.intellij.util.xml.GenericValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ReadOnlyGenericValue<T>
implements GenericValue<T> {
    public static <T> GenericValue<T> getInstance(final T value) {
        return new ReadOnlyGenericValue<T>(){

            @Override
            public T getValue() {
                return value;
            }
        };
    }

    public final void setStringValue(String value) {
        throw new UnsupportedOperationException("Model is read-only");
    }

    @Override
    public String getStringValue() {
        Object value = this.getValue();
        if (value == null) {
            return null;
        }
        if (value instanceof String) {
            return (String)value;
        }
        if (value instanceof PsiClass) {
            return ((PsiClass)value).getQualifiedName();
        }
        if (value instanceof PsiPackage) {
            return ((PsiPackage)value).getQualifiedName();
        }
        if (value instanceof PsiNamedElement) {
            return ((PsiNamedElement)value).getName();
        }
        return value.toString();
    }

    public final void setValue(T value) {
        throw new UnsupportedOperationException("Model is read-only");
    }

    public String toString() {
        return this.getStringValue();
    }
}

