/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.util.io.StreamUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.util.containers.Stack;
import com.intellij.util.text.CharSequenceReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.Properties;
import net.n3.nanoxml.IXMLBuilder;
import net.n3.nanoxml.IXMLEntityResolver;
import net.n3.nanoxml.IXMLParser;
import net.n3.nanoxml.IXMLReader;
import net.n3.nanoxml.IXMLValidator;
import net.n3.nanoxml.NonValidator;
import net.n3.nanoxml.StdXMLReader;
import net.n3.nanoxml.XMLException;
import net.n3.nanoxml.XMLParseException;
import net.n3.nanoxml.XMLParserFactory;
import org.jetbrains.annotations.Nullable;

public class NanoXmlUtil {
    private static final Logger LOG = Logger.getInstance("#com.intellij.util.xml.NanoXmlUtil");

    private NanoXmlUtil() {
    }

    public static void parseFile(PsiFile psiFile, IXMLBuilder builder) {
        block6: {
            try {
                InputStream inputStream;
                VirtualFile virtualFile = psiFile.getVirtualFile();
                if (virtualFile == null) {
                    NanoXmlUtil.parse(new StringReader(psiFile.getText()), builder);
                    return;
                }
                Document document = FileDocumentManager.getInstance().getCachedDocument(virtualFile);
                if (document != null) {
                    NanoXmlUtil.parse(new CharSequenceReader(document.getCharsSequence()), builder);
                    break block6;
                }
                try {
                    inputStream = virtualFile.getInputStream();
                }
                catch (FileNotFoundException e) {
                    return;
                }
                NanoXmlUtil.parse(inputStream, builder);
            }
            catch (IOException e) {
                LOG.error(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void parse(InputStream is, IXMLBuilder builder) {
        try {
            MyXMLReader r = new MyXMLReader(is);
            NanoXmlUtil.parse((IXMLReader)r, builder);
        }
        catch (IOException e) {
            LOG.error(e);
        }
        finally {
            try {
                is.close();
            }
            catch (IOException e) {
                LOG.error(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void parse(Reader reader, IXMLBuilder builder) {
        MyXMLReader r = new MyXMLReader(reader);
        try {
            NanoXmlUtil.parse((IXMLReader)r, builder);
        }
        catch (Exception e) {
            LOG.error(e);
        }
        finally {
            try {
                reader.close();
            }
            catch (IOException e) {
                LOG.error(e);
            }
        }
    }

    private static void parse(IXMLReader r, IXMLBuilder builder) {
        try {
            IXMLParser parser = XMLParserFactory.createDefaultXMLParser();
            parser.setReader(r);
            parser.setBuilder(builder);
            parser.setValidator((IXMLValidator)new EmptyValidator());
            parser.setResolver((IXMLEntityResolver)new EmptyEntityResolver());
            try {
                parser.parse();
            }
            catch (XMLException e) {
                if (e.getException() instanceof ParserStoppedException) {
                    return;
                }
                LOG.debug(e);
            }
        }
        catch (ClassNotFoundException e) {
            LOG.error(e);
        }
        catch (InstantiationException e) {
            LOG.error(e);
        }
        catch (IllegalAccessException e) {
            LOG.error(e);
        }
    }

    public static String createLocation(String ... tagNames) {
        StringBuffer result = new StringBuffer();
        for (String tagName : tagNames) {
            result.append(".");
            result.append(tagName);
        }
        return result.toString();
    }

    public static class RootTagNameBuilder
    implements IXMLBuilder {
        private String myRootTagName;

        public void startBuilding(String systemID, int lineNr) throws Exception {
        }

        public void newProcessingInstruction(String target, Reader reader) throws Exception {
        }

        public void startElement(String name, String nsPrefix, String nsURI, String systemID, int lineNr) throws Exception {
            this.myRootTagName = name;
            throw new ParserStoppedException();
        }

        public void addAttribute(String key, String nsPrefix, String nsURI, String value, String type) throws Exception {
        }

        public void elementAttributesProcessed(String name, String nsPrefix, String nsURI) throws Exception {
        }

        public void endElement(String name, String nsPrefix, String nsURI) throws Exception {
        }

        public void addPCData(Reader reader, String systemID, int lineNr) throws Exception {
        }

        public String getResult() {
            return this.myRootTagName;
        }
    }

    public static class ParserStoppedException
    extends RuntimeException {
    }

    private static class MyXMLReader
    extends StdXMLReader {
        public MyXMLReader(Reader documentReader) {
            super(documentReader);
        }

        public MyXMLReader(InputStream stream) throws IOException {
            super(stream);
        }

        public Reader openStream(String publicID, String systemID) throws IOException {
            return new StringReader(" ");
        }
    }

    private static class EmptyEntityResolver
    implements IXMLEntityResolver {
        private EmptyEntityResolver() {
        }

        public void addInternalEntity(String name, String value) {
        }

        public void addExternalEntity(String name, String publicID, String systemID) {
        }

        public Reader getEntity(IXMLReader xmlReader, String name) throws XMLParseException {
            return new StringReader("");
        }

        public boolean isExternalEntity(String name) {
            return false;
        }
    }

    private static class EmptyValidator
    extends NonValidator {
        private IXMLEntityResolver myParameterEntityResolver;

        private EmptyValidator() {
        }

        public void setParameterEntityResolver(IXMLEntityResolver resolver) {
            this.myParameterEntityResolver = resolver;
        }

        public IXMLEntityResolver getParameterEntityResolver() {
            return this.myParameterEntityResolver;
        }

        public void parseDTD(String publicID, IXMLReader reader, IXMLEntityResolver entityResolver, boolean external) throws Exception {
            if (!external) {
                int cnt = 1;
                char ch = reader.read();
                while (ch != ']' || --cnt != 0) {
                    if (ch == '[') {
                        ++cnt;
                    }
                    ch = reader.read();
                }
            } else {
                char ch;
                int origLevel = reader.getStreamLevel();
                do {
                    ch = reader.read();
                } while (reader.getStreamLevel() >= origLevel);
                reader.unread(ch);
                return;
            }
        }

        public void elementStarted(String name, String systemId, int lineNr) {
        }

        public void elementEnded(String name, String systemId, int lineNr) {
        }

        public void attributeAdded(String key, String value, String systemId, int lineNr) {
        }

        public void elementAttributesProcessed(String name, Properties extraAttributes, String systemId, int lineNr) {
        }

        public void PCDataAdded(String systemId, int lineNr) {
        }
    }

    public static class BaseXmlBuilder
    implements IXMLBuilder {
        private Stack<String> myLocation = new Stack();

        public void startBuilding(String systemID, int lineNr) throws Exception {
            this.myLocation.push("");
        }

        public void newProcessingInstruction(String target, Reader reader) throws Exception {
        }

        public void startElement(String name, String nsPrefix, String nsURI, String systemID, int lineNr) throws Exception {
            this.myLocation.push(this.myLocation.peek() + "." + name);
        }

        public void addAttribute(String key, String nsPrefix, String nsURI, String value, String type) throws Exception {
        }

        public void elementAttributesProcessed(String name, String nsPrefix, String nsURI) throws Exception {
        }

        public void endElement(String name, String nsPrefix, String nsURI) throws Exception {
            this.myLocation.pop();
        }

        public void addPCData(Reader reader, String systemID, int lineNr) throws Exception {
        }

        protected static String readText(Reader reader) throws IOException {
            return new String(StreamUtil.readTextAndConvertSeparators(reader));
        }

        @Nullable
        public Object getResult() throws Exception {
            return null;
        }

        protected String getLocation() {
            return this.myLocation.peek();
        }

        protected static void stop() {
            throw new ParserStoppedException();
        }
    }
}

