/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml;

import com.intellij.openapi.util.Comparing;
import com.intellij.util.Function;
import com.intellij.util.ReflectionCache;
import com.intellij.util.xml.NamedEnum;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NamedEnumUtil {
    private static final Function<Enum, String> NAMED_SHOW = new Function<Enum, String>(){

        @Override
        public String fun(Enum s) {
            return ((NamedEnum)((Object)s)).getValue();
        }
    };
    private static final Function<Enum, String> SIMPLE_SHOW = new Function<Enum, String>(){

        @Override
        public String fun(Enum s) {
            return s.name();
        }
    };

    public static <T extends Enum> T getEnumElementByValue(Class<T> enumClass, String value, Function<Enum, String> show) {
        for (Enum t : (Enum[])enumClass.getEnumConstants()) {
            if (!Comparing.equal(value, show.fun(t))) continue;
            return (T)t;
        }
        return null;
    }

    public static <T extends Enum> T getEnumElementByValue(Class<T> enumClass, String value) {
        return NamedEnumUtil.getEnumElementByValue(enumClass, value, NamedEnumUtil.getShow(enumClass));
    }

    private static <T extends Enum> Function<Enum, String> getShow(Class<T> enumClass) {
        return ReflectionCache.isAssignable(NamedEnum.class, enumClass) ? NAMED_SHOW : SIMPLE_SHOW;
    }

    public static <T extends Enum> String getEnumValueByElement(T element) {
        return element == null ? null : NamedEnumUtil.getShow(element.getClass()).fun(element);
    }
}

