/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml;

import com.intellij.util.containers.FactoryMap;
import com.intellij.util.xml.AnnotatedElement;
import com.intellij.util.xml.DomReflectionUtil;
import com.intellij.util.xml.JavaMethodSignature;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import org.jetbrains.annotations.NonNls;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class JavaMethod
implements AnnotatedElement {
    public static final JavaMethod[] EMPTY_ARRAY = new JavaMethod[0];
    private static final FactoryMap<JavaMethodSignature, FactoryMap<Class, JavaMethod>> ourMethods = new FactoryMap<JavaMethodSignature, FactoryMap<Class, JavaMethod>>(){

        @Override
        protected FactoryMap<Class, JavaMethod> create(final JavaMethodSignature signature) {
            return new FactoryMap<Class, JavaMethod>(){

                @Override
                protected JavaMethod create(Class key) {
                    return new JavaMethod(key, signature);
                }
            };
        }
    };
    private final JavaMethodSignature mySignature;
    private final Class myDeclaringClass;
    private final Method myMethod;

    private JavaMethod(Class declaringClass, JavaMethodSignature signature) {
        this.mySignature = signature;
        this.myMethod = signature.findMethod(declaringClass);
        assert (this.myMethod != null) : "No method " + signature + " in class " + declaringClass;
        this.myDeclaringClass = this.myMethod.getDeclaringClass();
    }

    public final Class getDeclaringClass() {
        return this.myDeclaringClass;
    }

    public final JavaMethodSignature getSignature() {
        return this.mySignature;
    }

    public final Method getMethod() {
        return this.myMethod;
    }

    public final Type[] getGenericParameterTypes() {
        return this.myMethod.getGenericParameterTypes();
    }

    public final Type getGenericReturnType() {
        return this.myMethod.getGenericReturnType();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JavaMethod getMethod(Class declaringClass, JavaMethodSignature signature) {
        FactoryMap<JavaMethodSignature, FactoryMap<Class, JavaMethod>> factoryMap = ourMethods;
        synchronized (factoryMap) {
            return ourMethods.get(signature).get(declaringClass);
        }
    }

    public static JavaMethod getMethod(Class declaringClass, Method method) {
        return JavaMethod.getMethod(declaringClass, JavaMethodSignature.getSignature(method));
    }

    public final Object invoke(Object o, Object ... args) {
        return DomReflectionUtil.invokeMethod(this.myMethod, o, args);
    }

    public String toString() {
        return "JavaMethod: " + this.myMethod.toString();
    }

    @NonNls
    public final String getName() {
        return this.myMethod.getName();
    }

    @Override
    public final <T extends Annotation> T getAnnotation(Class<T> annotationClass) {
        return this.mySignature.findAnnotation(annotationClass, this.myDeclaringClass);
    }

    public final Class getReturnType() {
        return this.myMethod.getReturnType();
    }

    public Class<?>[] getParameterTypes() {
        return this.myMethod.getParameterTypes();
    }
}

