/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml;

import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.codeStyle.NameUtil;
import com.intellij.util.Function;
import com.intellij.util.NullableFunction;
import com.intellij.util.ReflectionCache;
import com.intellij.util.containers.ConcurrentFactoryMap;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomReflectionUtil;
import com.intellij.util.xml.GenericValue;
import com.intellij.util.xml.ModelMergerUtil;
import com.intellij.util.xml.NameValue;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import net.sf.cglib.proxy.Factory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ElementPresentationManager {
    private static final ConcurrentFactoryMap<Class, Method> ourNameValueMethods = new ConcurrentFactoryMap<Class, Method>(){

        @Override
        @Nullable
        protected Method create(Class key) {
            for (Method method : ReflectionCache.getMethods(key)) {
                if (DomReflectionUtil.findAnnotationDFS(method, NameValue.class) == null) continue;
                return method;
            }
            return null;
        }
    };
    private static final Function<Object, String> DEFAULT_NAMER = new Function<Object, String>(){

        @Override
        @Nullable
        public String fun(Object element) {
            return ElementPresentationManager.getElementName(element);
        }
    };
    private static final Map<Class, String> ourTypeNames = new HashMap<Class, String>();
    private static final Map<Class, Icon[]> ourIcons = new HashMap<Class, Icon[]>();
    private static final List<Function<Object, String>> ourNameProviders = new ArrayList<Function<Object, String>>();
    private static final List<Function<Class, String>> ourTypeProviders = new ArrayList<Function<Class, String>>();
    private static final List<Function<Object, Icon>> ourIconProviders = new ArrayList<Function<Object, Icon>>();
    public static final NullableFunction<Object, String> NAMER = new NullableFunction<Object, String>(){

        @Override
        public String fun(Object o) {
            return ElementPresentationManager.getElementName(o);
        }
    };

    public static ElementPresentationManager getInstance() {
        return ServiceManager.getService(ElementPresentationManager.class);
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public <T> Object[] createVariants(Collection<T> elements) {
        Object[] objectArray = this.createVariants(elements, DEFAULT_NAMER);
        if (objectArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/util/xml/ElementPresentationManager.createVariants must not return null");
        }
        return objectArray;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public <T> Object[] createVariants(Collection<T> elements, int iconFlags) {
        Object[] objectArray = this.createVariants(elements, DEFAULT_NAMER, iconFlags);
        if (objectArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/util/xml/ElementPresentationManager.createVariants must not return null");
        }
        return objectArray;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public <T> Object[] createVariants(Collection<T> elements, Function<T, String> namer) {
        Object[] objectArray = this.createVariants(elements, namer, 0);
        if (objectArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/util/xml/ElementPresentationManager.createVariants must not return null");
        }
        return objectArray;
    }

    @NotNull
    public abstract <T> Object[] createVariants(Collection<T> var1, Function<T, String> var2, int var3);

    public static void registerNameProvider(Function<Object, String> function) {
        ourNameProviders.add(function);
    }

    public static void registerTypeProvider(Function<Class, String> function) {
        ourTypeProviders.add(function);
    }

    public static void registerIconProvider(Function<Object, Icon> function) {
        ourIconProviders.add(function);
    }

    public static void unregisterNameProvider(Function<Object, String> function) {
        ourNameProviders.remove(function);
    }

    public static void unregisterTypeProvider(Function<Class, String> function) {
        ourTypeProviders.remove(function);
    }

    public static void unregisterIconProvider(Function<Object, Icon> function) {
        ourIconProviders.remove(function);
    }

    public static void registerTypeName(Class aClass, String typeName) {
        ourTypeNames.put(aClass, typeName);
    }

    public static void registerIcon(Class aClass, Icon icon) {
        ElementPresentationManager.registerIcons(aClass, icon);
    }

    public static void registerIcons(Class aClass, Icon ... icon) {
        ourIcons.put(aClass, icon);
    }

    @Nullable
    public static String getElementName(Object element) {
        for (Function<Object, String> function : ourNameProviders) {
            String s = function.fun(element);
            if (s == null) continue;
            return s;
        }
        Object o = ElementPresentationManager.invokeNameValueMethod(element);
        return o == null || o instanceof String ? (String)o : ((GenericValue)o).getStringValue();
    }

    @Nullable
    public static Object invokeNameValueMethod(Object element) {
        Method nameValueMethod = ElementPresentationManager.findNameValueMethod(element.getClass());
        if (nameValueMethod == null) {
            return null;
        }
        return DomReflectionUtil.invokeMethod(nameValueMethod, element, new Object[0]);
    }

    public static String getTypeNameForObject(Object o) {
        Object firstImpl = ModelMergerUtil.getFirstImplementation(o);
        Class<?> aClass = (o = firstImpl != null ? firstImpl : o).getClass();
        String s = ElementPresentationManager._getTypeName(aClass);
        if (s != null) {
            return s;
        }
        if (o instanceof DomElement) {
            DomElement element = (DomElement)o;
            return StringUtil.capitalizeWords(element.getNameStrategy().splitIntoWords(element.getXmlElementName()), true);
        }
        return ElementPresentationManager.getDefaultTypeName(aClass);
    }

    public static String getTypeName(Class aClass) {
        String s = ElementPresentationManager._getTypeName(aClass);
        if (s != null) {
            return s;
        }
        return ElementPresentationManager.getDefaultTypeName(aClass);
    }

    private static String getDefaultTypeName(Class aClass) {
        String simpleName = aClass.getSimpleName();
        int i = simpleName.indexOf(36);
        if (i >= 0) {
            simpleName = Factory.class.isAssignableFrom(aClass) ? simpleName.substring(0, i) : simpleName.substring(i + 1);
        }
        return StringUtil.capitalizeWords(StringUtil.join(NameUtil.nameToWords(simpleName), " "), true);
    }

    @Nullable
    private static <T> T getFromClassMap(Map<Class, T> map, Class value) {
        for (Map.Entry<Class, T> entry : map.entrySet()) {
            if (!entry.getKey().isAssignableFrom(value)) continue;
            return entry.getValue();
        }
        return null;
    }

    @Nullable
    private static String _getTypeName(Class aClass) {
        for (Function<Class, String> function : ourTypeProviders) {
            String s = function.fun(aClass);
            if (s == null) continue;
            return s;
        }
        return ElementPresentationManager.getFromClassMap(ourTypeNames, aClass);
    }

    @Nullable
    public static Icon getIcon(Object o) {
        return ElementPresentationManager.getFirst(ElementPresentationManager.getIcons(o));
    }

    @Nullable
    private static <T> T getFirst(@Nullable T[] array) {
        return array == null || array.length == 0 ? null : (T)array[0];
    }

    @Nullable
    public static Icon getLargeIcon(@Nullable Icon[] icons) {
        if (icons == null || icons.length == 0) {
            return null;
        }
        Icon largest = icons[0];
        for (int i = 1; i < icons.length; ++i) {
            Icon icon = icons[i];
            if (icon.getIconWidth() <= largest.getIconWidth()) continue;
            largest = icon;
        }
        return largest;
    }

    @Nullable
    public static Icon getSmallIcon(@Nullable Icon[] icons) {
        if (icons == null || icons.length == 0) {
            return null;
        }
        Icon smallest = icons[0];
        for (int i = 1; i < icons.length; ++i) {
            Icon icon = icons[i];
            if (icon.getIconWidth() >= smallest.getIconWidth()) continue;
            smallest = icon;
        }
        return smallest;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static Icon[] getIcons(Object o) {
        Object firstImpl = ModelMergerUtil.getFirstImplementation(o);
        o = firstImpl != null ? firstImpl : o;
        ArrayList<Icon> result = new ArrayList<Icon>();
        for (Function<Object, Icon> function : ourIconProviders) {
            Icon icon = function.fun(o);
            if (icon == null) continue;
            result.add(icon);
        }
        Icon[] icons = ElementPresentationManager.getIconsForClass(o.getClass());
        if (icons != null) {
            result.addAll(Arrays.asList(icons));
        }
        Icon[] iconArray = result.toArray(new Icon[result.size()]);
        if (iconArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/util/xml/ElementPresentationManager.getIcons must not return null");
        }
        return iconArray;
    }

    @Nullable
    public static Icon getIconForClass(Class clazz) {
        return ElementPresentationManager.getFirst(ElementPresentationManager.getIconsForClass(clazz));
    }

    @Nullable
    public static Icon[] getIconsForClass(Class clazz) {
        return ElementPresentationManager.getFromClassMap(ourIcons, clazz);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Method findNameValueMethod(Class<? extends Object> aClass) {
        ConcurrentFactoryMap<Class, Method> concurrentFactoryMap = ourNameValueMethods;
        synchronized (concurrentFactoryMap) {
            return (Method)ourNameValueMethods.get(aClass);
        }
    }

    @Nullable
    public static <T> T findByName(Collection<T> collection, final String name) {
        return (T)ContainerUtil.find(collection, new Condition<T>(){

            @Override
            public boolean value(T object) {
                return Comparing.equal(name, ElementPresentationManager.getElementName(object));
            }
        });
    }
}

