/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.ReflectionCache;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomElementVisitor;
import com.intellij.util.xml.DomFileElement;
import com.intellij.util.xml.DomManager;
import com.intellij.util.xml.DomReflectionUtil;
import com.intellij.util.xml.ElementPresentationManager;
import com.intellij.util.xml.GenericAttributeValue;
import com.intellij.util.xml.GenericDomValue;
import com.intellij.util.xml.GenericValue;
import com.intellij.util.xml.JavaMethod;
import com.intellij.util.xml.MergedObject;
import com.intellij.util.xml.NameValue;
import com.intellij.util.xml.reflect.DomAttributeChildDescription;
import com.intellij.util.xml.reflect.DomCollectionChildDescription;
import com.intellij.util.xml.reflect.DomFixedChildDescription;
import com.intellij.util.xml.reflect.DomGenericInfo;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DomUtil {
    public static final TypeVariable<Class<GenericValue>> GENERIC_VALUE_TYPE_VARIABLE = ReflectionCache.getTypeParameters(GenericValue.class)[0];

    private DomUtil() {
    }

    public static Class extractParameterClassFromGenericType(Type type) {
        return DomUtil.getGenericValueParameter(type);
    }

    public static boolean isGenericValueType(Type type) {
        return DomUtil.getGenericValueParameter(type) != null;
    }

    @Nullable
    public static <T extends DomElement> T findByName(@NotNull Collection<T> list, @NonNls @NotNull String name) {
        if (list == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/xml/DomUtil.findByName must not be null");
        }
        if (name == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/util/xml/DomUtil.findByName must not be null");
        }
        for (DomElement element : list) {
            String elementName = element.getGenericInfo().getElementName(element);
            if (elementName == null || !elementName.equals(name)) continue;
            return (T)element;
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static String[] getElementNames(@NotNull Collection<? extends DomElement> list) {
        if (list == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/xml/DomUtil.getElementNames must not be null");
        }
        ArrayList<String> result = new ArrayList<String>(list.size());
        if (list.size() > 0) {
            for (DomElement domElement : list) {
                String name = domElement.getGenericInfo().getElementName(domElement);
                if (name == null) continue;
                result.add(name);
            }
        }
        String[] stringArray = result.toArray(new String[result.size()]);
        if (stringArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/util/xml/DomUtil.getElementNames must not return null");
        }
        return stringArray;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static List<XmlTag> getElementTags(@NotNull Collection<? extends DomElement> list) {
        if (list == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/xml/DomUtil.getElementTags must not be null");
        }
        ArrayList<XmlTag> result = new ArrayList<XmlTag>(list.size());
        for (DomElement domElement : list) {
            XmlTag tag = domElement.getXmlTag();
            if (tag == null) continue;
            result.add(tag);
        }
        ArrayList<XmlTag> arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException("@NotNull method com/intellij/util/xml/DomUtil.getElementTags must not return null");
        }
        return arrayList;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static XmlTag[] getElementTags(@NotNull DomElement[] list) {
        if (list == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/xml/DomUtil.getElementTags must not be null");
        }
        XmlTag[] result = new XmlTag[list.length];
        int i = 0;
        for (DomElement element : list) {
            XmlTag tag = element.getXmlTag();
            if (tag == null) continue;
            result[i++] = tag;
        }
        if (result == null) {
            throw new IllegalStateException("@NotNull method com/intellij/util/xml/DomUtil.getElementTags must not return null");
        }
        return result;
    }

    @Nullable
    public static List<JavaMethod> getFixedPath(DomElement element) {
        DomElement parent;
        assert (element.isValid());
        LinkedList<JavaMethod> methods = new LinkedList<JavaMethod>();
        while (!((parent = element.getParent()) instanceof DomFileElement)) {
            JavaMethod method = DomUtil.getGetterMethod(element, parent);
            if (method == null) {
                return null;
            }
            methods.addFirst(method);
            element = element.getParent();
        }
        return methods;
    }

    @Nullable
    private static JavaMethod getGetterMethod(DomElement element, DomElement parent) {
        String xmlElementName = element.getXmlElementName();
        String namespace = element.getXmlElementNamespaceKey();
        DomGenericInfo genericInfo = parent.getGenericInfo();
        if (element instanceof GenericAttributeValue) {
            DomAttributeChildDescription description = genericInfo.getAttributeChildDescription(xmlElementName, namespace);
            assert (description != null);
            return description.getGetterMethod();
        }
        DomFixedChildDescription description = genericInfo.getFixedChildDescription(xmlElementName, namespace);
        return description != null ? description.getGetterMethod(description.getValues(parent).indexOf(element)) : null;
    }

    public static Class getGenericValueParameter(Type type) {
        return ReflectionUtil.substituteGenericType(GENERIC_VALUE_TYPE_VARIABLE, type);
    }

    @Nullable
    public static XmlElement getValueElement(GenericDomValue domValue) {
        if (domValue instanceof GenericAttributeValue) {
            GenericAttributeValue value = (GenericAttributeValue)domValue;
            XmlAttributeValue attributeValue = value.getXmlAttributeValue();
            return attributeValue == null ? value.getXmlAttribute() : attributeValue;
        }
        return domValue.getXmlTag();
    }

    public static List<? extends DomElement> getIdentitySiblings(DomElement element) {
        String tagName;
        DomElement parent;
        DomGenericInfo domGenericInfo;
        DomCollectionChildDescription childDescription;
        String stringValue;
        NameValue nameValue;
        Method nameValueMethod = ElementPresentationManager.findNameValueMethod(element.getClass());
        if (nameValueMethod != null && ((nameValue = DomReflectionUtil.findAnnotationDFS(nameValueMethod, NameValue.class)) == null || nameValue.unique()) && (stringValue = ElementPresentationManager.getElementName(element)) != null && (childDescription = (domGenericInfo = (parent = element.getManager().getIdentityScope(element)).getGenericInfo()).getCollectionChildDescription(tagName = element.getXmlElementName(), element.getXmlElementNamespaceKey())) != null) {
            ArrayList<? extends DomElement> list = new ArrayList<DomElement>(childDescription.getValues(parent));
            list.remove(element);
            return list;
        }
        return Collections.emptyList();
    }

    public static <T> List<T> getChildrenOfType(@NotNull DomElement parent, final Class<T> type) {
        if (parent == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/xml/DomUtil.getChildrenOfType must not be null");
        }
        final SmartList result = new SmartList();
        parent.acceptChildren(new DomElementVisitor(){

            public void visitDomElement(DomElement element) {
                if (type.isInstance(element)) {
                    result.add(element);
                }
            }
        });
        return result;
    }

    public static List<DomElement> getDefinedChildren(@NotNull DomElement parent, boolean tags, boolean attributes) {
        if (parent == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/xml/DomUtil.getDefinedChildren must not be null");
        }
        if (parent instanceof MergedObject) {
            final SmartList<DomElement> result = new SmartList<DomElement>();
            parent.acceptChildren(new DomElementVisitor(){

                public void visitDomElement(DomElement element) {
                    if (element.getXmlElement() != null) {
                        result.add(element);
                    }
                }
            });
            return result;
        }
        ProgressManager.getInstance().checkCanceled();
        if (parent instanceof GenericAttributeValue) {
            return Collections.emptyList();
        }
        if (parent instanceof DomFileElement) {
            DomFileElement element = (DomFileElement)parent;
            return tags ? Arrays.asList(element.getRootElement()) : Collections.emptyList();
        }
        XmlElement xmlElement = parent.getXmlElement();
        if (xmlElement instanceof XmlTag) {
            XmlTag tag = (XmlTag)xmlElement;
            DomManager domManager = parent.getManager();
            SmartList<DomElement> result = new SmartList<DomElement>();
            if (attributes) {
                for (XmlElement xmlElement2 : tag.getAttributes()) {
                    ContainerUtil.addIfNotNull(domManager.getDomElement((XmlAttribute)xmlElement2), result);
                }
            }
            if (tags) {
                for (XmlElement xmlElement3 : tag.getSubTags()) {
                    ContainerUtil.addIfNotNull(domManager.getDomElement((XmlTag)xmlElement3), result);
                }
            }
            return result;
        }
        return Collections.emptyList();
    }

    public static <T> List<T> getDefinedChildrenOfType(@NotNull DomElement parent, Class<T> type, boolean tags, boolean attributes) {
        if (parent == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/xml/DomUtil.getDefinedChildrenOfType must not be null");
        }
        return ContainerUtil.findAll(DomUtil.getDefinedChildren(parent, tags, attributes), type);
    }

    public static <T> List<T> getDefinedChildrenOfType(@NotNull DomElement parent, Class<T> type) {
        if (parent == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/xml/DomUtil.getDefinedChildrenOfType must not be null");
        }
        return DomUtil.getDefinedChildrenOfType(parent, type, true, true);
    }

    @Nullable
    public static DomElement findDuplicateNamedValue(DomElement element, String newName) {
        return ElementPresentationManager.findByName(DomUtil.getIdentitySiblings(element), newName);
    }

    public static boolean isAncestor(@NotNull DomElement ancestor, @NotNull DomElement descendant, boolean strict) {
        if (ancestor == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/xml/DomUtil.isAncestor must not be null");
        }
        if (descendant == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/util/xml/DomUtil.isAncestor must not be null");
        }
        if (!strict && ancestor.equals(descendant)) {
            return true;
        }
        DomElement parent = descendant.getParent();
        return parent != null && DomUtil.isAncestor(ancestor, parent, false);
    }

    public static void acceptAvailableChildren(DomElement element, DomElementVisitor visitor) {
        XmlTag tag = element.getXmlTag();
        if (tag != null) {
            for (XmlTag xmlTag : tag.getSubTags()) {
                DomElement childElement = element.getManager().getDomElement(xmlTag);
                if (childElement == null) continue;
                childElement.accept(visitor);
            }
        }
    }

    public static Collection<Class> getAllInterfaces(Class aClass, Collection<Class> result) {
        Class[] interfaces = ReflectionCache.getInterfaces(aClass);
        result.addAll(Arrays.asList(interfaces));
        if (aClass.getSuperclass() != null) {
            DomUtil.getAllInterfaces(aClass.getSuperclass(), result);
        }
        for (Class anInterface : interfaces) {
            DomUtil.getAllInterfaces(anInterface, result);
        }
        return result;
    }

    @Nullable
    public static <T> T getParentOfType(DomElement element, Class<T> requiredClass, boolean strict) {
        DomElement curElement;
        DomElement domElement = curElement = strict && element != null ? element.getParent() : element;
        while (curElement != null) {
            if (requiredClass.isInstance(curElement)) {
                return (T)curElement;
            }
            curElement = curElement.getParent();
        }
        return null;
    }

    @Nullable
    public static DomElement getContextElement(@Nullable Editor editor) {
        if (editor == null) {
            return null;
        }
        Project project = editor.getProject();
        if (project == null) {
            return null;
        }
        PsiFile file = PsiDocumentManager.getInstance(project).getPsiFile(editor.getDocument());
        if (!(file instanceof XmlFile)) {
            return null;
        }
        return DomUtil.getDomElement(file.findElementAt(editor.getCaretModel().getOffset()));
    }

    @Nullable
    public static DomElement getDomElement(Editor editor, PsiFile file) {
        return DomUtil.getDomElement(file.findElementAt(editor.getCaretModel().getOffset()));
    }

    @Nullable
    public static DomElement getDomElement(@Nullable PsiElement element) {
        GenericAttributeValue value;
        if (element == null) {
            return null;
        }
        Project project = element.getProject();
        DomManager domManager = DomManager.getDomManager(project);
        XmlAttribute attr = PsiTreeUtil.getParentOfType(element, XmlAttribute.class, false);
        if (attr != null && (value = domManager.getDomElement(attr)) != null) {
            return value;
        }
        for (XmlTag tag = PsiTreeUtil.getParentOfType(element, XmlTag.class, false); tag != null; tag = tag.getParentTag()) {
            DomElement domElement = domManager.getDomElement(tag);
            if (domElement == null) continue;
            return domElement;
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static <T extends DomElement> T getOriginalElement(@NotNull T domElement) {
        Object object;
        if (domElement == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/xml/DomUtil.getOriginalElement must not be null");
        }
        XmlElement psiElement = domElement.getXmlElement();
        if (psiElement == null) {
            object = domElement;
            if (object == null) throw new IllegalStateException("@NotNull method com/intellij/util/xml/DomUtil.getOriginalElement must not return null");
            return object;
        }
        PsiFile psiFile = psiElement.getContainingFile();
        PsiFile originalFile = psiFile.getOriginalFile();
        if (originalFile == null) {
            object = domElement;
            if (object == null) throw new IllegalStateException("@NotNull method com/intellij/util/xml/DomUtil.getOriginalElement must not return null");
            return object;
        }
        TextRange range = psiElement.getTextRange();
        PsiElement element = originalFile.findElementAt(range.getStartOffset());
        int maxLength = range.getLength();
        boolean isAttribute = psiElement instanceof XmlAttribute;
        Class clazz = isAttribute ? XmlAttribute.class : XmlTag.class;
        DomManager domManager = domElement.getManager();
        DomElement current = null;
        XmlElement next = PsiTreeUtil.getParentOfType(element, clazz, false);
        while (next != null && next.getTextLength() <= maxLength) {
            DomElement domElement2 = current = isAttribute ? domManager.getDomElement((XmlAttribute)next) : domManager.getDomElement((XmlTag)next);
            if (current != null && domElement.getClass() != current.getClass()) {
                current = null;
            }
            next = PsiTreeUtil.getParentOfType((PsiElement)next, clazz, true);
        }
        object = current;
        if (object != null) return object;
        throw new IllegalStateException("@NotNull method com/intellij/util/xml/DomUtil.getOriginalElement must not return null");
    }
}

