/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiManager;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.util.containers.FactoryMap;
import com.intellij.util.containers.SoftFactoryMap;
import com.intellij.util.xml.ConvertContext;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomManager;
import com.intellij.util.xml.DomUtil;
import com.intellij.util.xml.ElementPresentationManager;
import com.intellij.util.xml.GenericAttributeValue;
import com.intellij.util.xml.GenericDomValue;
import com.intellij.util.xml.ResolvingConverter;
import com.intellij.util.xml.highlighting.ResolvingElementQuickFix;
import gnu.trove.THashMap;
import java.util.Collection;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DomResolveConverter<T extends DomElement>
extends ResolvingConverter<T> {
    private static final FactoryMap<Class<? extends DomElement>, DomResolveConverter> ourCache = new FactoryMap<Class<? extends DomElement>, DomResolveConverter>(){

        /*
         * Enabled aggressive block sorting
         */
        @Override
        @NotNull
        protected DomResolveConverter create(Class<? extends DomElement> key) {
            DomResolveConverter<? extends DomElement> domResolveConverter = new DomResolveConverter<DomElement>(key);
            if (domResolveConverter == null) {
                throw new IllegalStateException("@NotNull method com/intellij/util/xml/DomResolveConverter$1.create must not return null");
            }
            return domResolveConverter;
        }
    };
    private final boolean myAttribute;
    private final SoftFactoryMap<DomElement, CachedValue<Map<String, DomElement>>> myResolveCache = new SoftFactoryMap<DomElement, CachedValue<Map<String, DomElement>>>(){

        /*
         * Enabled aggressive block sorting
         */
        @Override
        @NotNull
        protected CachedValue<Map<String, DomElement>> create(final DomElement scope) {
            DomManager domManager = scope.getManager();
            Project project = domManager.getProject();
            CachedValue<Map<String, DomElement>> cachedValue = PsiManager.getInstance(project).getCachedValuesManager().createCachedValue(new CachedValueProvider<Map<String, DomElement>>(){

                @Override
                public CachedValueProvider.Result<Map<String, DomElement>> compute() {
                    THashMap map = new THashMap();
                    this.visitDomElement(scope, (Map<String, DomElement>)map);
                    return new CachedValueProvider.Result<THashMap>(map, PsiModificationTracker.OUT_OF_CODE_BLOCK_MODIFICATION_COUNT);
                }

                private void visitDomElement(DomElement element, Map<String, DomElement> map) {
                    if (DomResolveConverter.this.myClass.isInstance(element)) {
                        String name = ElementPresentationManager.getElementName(element);
                        if (name != null && !map.containsKey(name)) {
                            map.put(name, element);
                        }
                    } else {
                        for (DomElement child : DomUtil.getDefinedChildren(element, true, DomResolveConverter.this.myAttribute)) {
                            this.visitDomElement(child, map);
                        }
                    }
                }
            }, false);
            if (cachedValue == null) {
                throw new IllegalStateException("@NotNull method com/intellij/util/xml/DomResolveConverter$2.create must not return null");
            }
            return cachedValue;
        }
    };
    private final Class<T> myClass;

    public DomResolveConverter(Class<T> aClass) {
        this.myClass = aClass;
        this.myAttribute = GenericAttributeValue.class.isAssignableFrom(this.myClass);
    }

    public static <T extends DomElement> DomResolveConverter<T> createConverter(Class<T> aClass) {
        return ourCache.get(aClass);
    }

    @Override
    public final T fromString(String s, ConvertContext context) {
        if (s == null) {
            return null;
        }
        return (T)this.myResolveCache.get(DomResolveConverter.getResolvingScope(context)).getValue().get(s);
    }

    private static DomElement getResolvingScope(ConvertContext context) {
        DomElement invocationElement = context.getInvocationElement();
        return invocationElement.getManager().getResolvingScope((GenericDomValue)invocationElement);
    }

    @Override
    public String getErrorMessage(String s, ConvertContext context) {
        return CodeInsightBundle.message("error.cannot.resolve.0.1", ElementPresentationManager.getTypeName(this.myClass), s);
    }

    @Override
    public final String toString(T t, ConvertContext context) {
        if (t == null) {
            return null;
        }
        return ElementPresentationManager.getElementName(t);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @NotNull
    public Collection<? extends T> getVariants(ConvertContext context) {
        DomElement reference = context.getInvocationElement();
        DomElement scope = reference.getManager().getResolvingScope((GenericDomValue)reference);
        Collection<DomElement> collection = this.myResolveCache.get(scope).getValue().values();
        if (collection == null) {
            throw new IllegalStateException("@NotNull method com/intellij/util/xml/DomResolveConverter.getVariants must not return null");
        }
        return collection;
    }

    @Override
    public LocalQuickFix[] getQuickFixes(ConvertContext context) {
        DomElement element = context.getInvocationElement();
        GenericDomValue value = (GenericDomValue)((GenericDomValue)element).createStableCopy();
        String newName = value.getStringValue();
        if (newName == null) {
            return LocalQuickFix.EMPTY_ARRAY;
        }
        DomElement scope = value.getManager().getResolvingScope(value);
        return ResolvingElementQuickFix.createFixes(newName, this.myClass, scope);
    }
}

