/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.ide.IdeBundle;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiType;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.xml.ConvertContext;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Converter<T> {
    @Deprecated
    public static final Converter<Integer> INTEGER_CONVERTER = new Converter<Integer>(){

        @Override
        public Integer fromString(String s, ConvertContext context) {
            if (s == null) {
                return null;
            }
            try {
                return Integer.decode(s);
            }
            catch (Exception e) {
                return null;
            }
        }

        @Override
        public String toString(Integer t, ConvertContext context) {
            return t == null ? null : t.toString();
        }

        @Override
        public String getErrorMessage(String s, ConvertContext context) {
            return IdeBundle.message("value.should.be.integer", new Object[0]);
        }
    };
    @Deprecated
    public static final Converter<String> EMPTY_CONVERTER = new Converter<String>(){

        @Override
        public String fromString(String s, ConvertContext context) {
            return s;
        }

        @Override
        public String toString(String t, ConvertContext context) {
            return t;
        }
    };
    @Deprecated
    public static final Converter<PsiClass> PSI_CLASS_CONVERTER = new Converter<PsiClass>(){

        @Override
        public PsiClass fromString(String s, ConvertContext context) {
            return s == null ? null : context.findClass(s, null);
        }

        @Override
        public String toString(PsiClass t, ConvertContext context) {
            return t == null ? null : t.getQualifiedName();
        }
    };
    @Deprecated
    public static final Converter<PsiType> PSI_TYPE_CONVERTER = new Converter<PsiType>(){

        @Override
        public PsiType fromString(String s, ConvertContext context) {
            if (s == null) {
                return null;
            }
            try {
                return context.getFile().getManager().getElementFactory().createTypeFromText(s, null);
            }
            catch (IncorrectOperationException e) {
                return null;
            }
        }

        @Override
        public String toString(PsiType t, ConvertContext context) {
            return t == null ? null : t.getCanonicalText();
        }
    };

    @Nullable
    public abstract T fromString(@Nullable @NonNls String var1, ConvertContext var2);

    @Nullable
    public abstract String toString(@Nullable T var1, ConvertContext var2);

    @Nullable
    public String getErrorMessage(@Nullable String s, ConvertContext context) {
        return CodeInsightBundle.message("error.cannot.convert.default.message", s);
    }
}

