/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml;

import com.intellij.openapi.module.Module;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.xml.ConvertContext;
import com.intellij.util.xml.DomElement;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractConvertContext
extends ConvertContext {
    public static ConvertContext createConvertContext(final DomElement domElement) {
        return new AbstractConvertContext(){

            /*
             * Enabled aggressive block sorting
             */
            @NotNull
            public DomElement getInvocationElement() {
                DomElement domElement2 = domElement;
                if (domElement2 == null) {
                    throw new IllegalStateException("@NotNull method com/intellij/util/xml/AbstractConvertContext$1.getInvocationElement must not return null");
                }
                return domElement2;
            }
        };
    }

    public final PsiClass findClass(@Nullable String name, @Nullable GlobalSearchScope searchScope) {
        return AbstractConvertContext.findClass(name, this.getFile(), this.getModule(), searchScope);
    }

    @Nullable
    public static PsiClass findClass(@Nullable String name, @NotNull XmlFile file, @Nullable Module module, @Nullable GlobalSearchScope searchScope) {
        if (file == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/util/xml/AbstractConvertContext.findClass must not be null");
        }
        if (name == null) {
            return null;
        }
        if (name.indexOf(36) >= 0) {
            name = name.replace('$', '.');
        }
        GlobalSearchScope scope = searchScope == null ? (module != null ? GlobalSearchScope.moduleWithDependenciesAndLibrariesScope(module) : file.getResolveScope()) : searchScope;
        PsiClass aClass = file.getManager().findClass(name, scope);
        if (aClass != null) assert (aClass.isValid()) : name;
        return aClass;
    }

    public final XmlTag getTag() {
        return this.getInvocationElement().getXmlTag();
    }

    @Nullable
    public XmlElement getXmlElement() {
        return this.getInvocationElement().getXmlElement();
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public final XmlFile getFile() {
        XmlFile xmlFile = this.getInvocationElement().getRoot().getFile();
        if (xmlFile == null) {
            throw new IllegalStateException("@NotNull method com/intellij/util/xml/AbstractConvertContext.getFile must not return null");
        }
        return xmlFile;
    }

    public Module getModule() {
        return this.getInvocationElement().getRoot().getRootElement().getModule();
    }

    public PsiManager getPsiManager() {
        return this.getFile().getManager();
    }
}

