/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.ui.update;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.ui.update.Activatable;
import java.awt.Component;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;

public class UiNotifyConnector
implements Disposable,
HierarchyListener {
    private Component myComponent;
    private Activatable myTarget;

    public UiNotifyConnector(Component component, Activatable target) {
        this.myComponent = component;
        this.myTarget = target;
        if (component.isShowing()) {
            this.showNotify();
        } else {
            this.hideNotify();
        }
        component.addHierarchyListener(this);
    }

    public void hierarchyChanged(HierarchyEvent e) {
        if ((e.getChangeFlags() & 4L) > 0L) {
            ApplicationManager.getApplication().invokeLater(new Runnable(){

                public void run() {
                    if (UiNotifyConnector.this.myComponent == null) {
                        return;
                    }
                    if (UiNotifyConnector.this.myComponent.isShowing()) {
                        UiNotifyConnector.this.showNotify();
                    } else {
                        UiNotifyConnector.this.hideNotify();
                    }
                }
            }, ModalityState.stateForComponent(this.myComponent));
        }
    }

    protected void hideNotify() {
        this.myTarget.hideNotify();
    }

    protected void showNotify() {
        this.myTarget.showNotify();
    }

    public void dispose() {
        if (this.myTarget == null) {
            return;
        }
        this.myTarget.hideNotify();
        this.myComponent.removeHierarchyListener(this);
        this.myTarget = null;
        this.myComponent = null;
    }

    public static class Once
    extends UiNotifyConnector {
        private boolean myShown;
        private boolean myHidden;

        public Once(Component component, Activatable target) {
            super(component, target);
        }

        protected final void hideNotify() {
            super.hideNotify();
            this.myHidden = true;
            this.disposeIfNeeded();
        }

        protected final void showNotify() {
            super.showNotify();
            this.myShown = true;
            this.disposeIfNeeded();
        }

        private void disposeIfNeeded() {
            if (this.myShown && this.myHidden) {
                Disposer.dispose(this);
            }
        }
    }
}

