/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.ui.update;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.util.Alarm;
import com.intellij.util.ui.update.Activatable;
import com.intellij.util.ui.update.Update;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.JComponent;
import org.jetbrains.annotations.NonNls;

public class MergingUpdateQueue
implements Runnable,
Disposable,
Activatable {
    private boolean myActive;
    private final Set<Update> mySheduledUpdates = new TreeSet<Update>();
    private Alarm myWaiterForMerge = new Alarm(Alarm.ThreadToUse.SWING_THREAD);
    private volatile boolean myFlushing;
    private String myName;
    private int myMergingTimeSpan;
    private final JComponent myComponent;
    private boolean myPassThrough;
    private boolean myDisposed;

    public MergingUpdateQueue(@NonNls String name, int mergingTimeSpan, boolean isActive, JComponent component) {
        this.myMergingTimeSpan = mergingTimeSpan;
        this.myComponent = component;
        this.myName = name;
        this.myPassThrough = ApplicationManager.getApplication().isUnitTestMode();
        if (isActive) {
            this.showNotify();
        }
    }

    public void setMergingTimeSpan(int timeSpan) {
        this.myMergingTimeSpan = timeSpan;
        if (this.myActive) {
            this.restartTimer();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancelAllUpdates() {
        Set<Update> set = this.mySheduledUpdates;
        synchronized (set) {
            this.mySheduledUpdates.clear();
        }
    }

    public final boolean isPassThrough() {
        return this.myPassThrough;
    }

    public final void setPassThrough(boolean passThrough) {
        this.myPassThrough = passThrough;
    }

    public void hideNotify() {
        if (!this.myActive) {
            return;
        }
        this.myActive = false;
        this.clearWaiter();
    }

    public void showNotify() {
        if (this.myActive) {
            return;
        }
        this.restartTimer();
        this.myActive = true;
        this.flush();
    }

    private void restartTimer() {
        this.clearWaiter();
        this.myWaiterForMerge.addRequest(this, this.myMergingTimeSpan, this.getModalityState());
    }

    public void run() {
        this.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush() {
        Set<Update> set = this.mySheduledUpdates;
        synchronized (set) {
            if (this.mySheduledUpdates.isEmpty()) {
                return;
            }
        }
        this.flush(true);
    }

    public void flush(boolean invokeLaterIfNotDispatch) {
        if (this.myFlushing) {
            return;
        }
        if (!this.isModalityStateCorrect()) {
            return;
        }
        this.myFlushing = true;
        Runnable toRun = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    Update[] all;
                    Set set = MergingUpdateQueue.this.mySheduledUpdates;
                    synchronized (set) {
                        all = MergingUpdateQueue.this.mySheduledUpdates.toArray(new Update[MergingUpdateQueue.this.mySheduledUpdates.size()]);
                        MergingUpdateQueue.this.mySheduledUpdates.clear();
                    }
                    for (Update each : all) {
                        each.setProcessed();
                    }
                    MergingUpdateQueue.this.execute(all);
                }
                finally {
                    MergingUpdateQueue.this.myFlushing = false;
                }
            }
        };
        if (invokeLaterIfNotDispatch && !ApplicationManager.getApplication().isDispatchThread()) {
            ApplicationManager.getApplication().invokeLater(toRun, ModalityState.NON_MODAL);
        } else {
            toRun.run();
        }
    }

    private boolean isModalityStateCorrect() {
        ModalityState modalityState;
        ModalityState current = ApplicationManager.getApplication().getCurrentModalityState();
        return !current.dominates(modalityState = this.getModalityState());
    }

    private static boolean isExpired(Update each) {
        return each.isDisposed() || each.isExpired();
    }

    protected void execute(Update[] update) {
        for (final Update each : update) {
            if (MergingUpdateQueue.isExpired(each)) continue;
            if (each.executeInWriteAction()) {
                ApplicationManager.getApplication().runWriteAction(new Runnable(){

                    public void run() {
                        MergingUpdateQueue.execute(each);
                    }
                });
                continue;
            }
            MergingUpdateQueue.execute(each);
        }
    }

    private static void execute(Update each) {
        each.run();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void queue(final Update update) {
        Application app = ApplicationManager.getApplication();
        if (this.myPassThrough) {
            app.invokeLater(new Runnable(){

                public void run() {
                    if (MergingUpdateQueue.this.myDisposed) {
                        return;
                    }
                    update.run();
                }
            });
            return;
        }
        boolean active = this.myActive;
        Set<Update> set = this.mySheduledUpdates;
        synchronized (set) {
            if (this.eatThisOrOthers(update)) {
                return;
            }
            if (active && this.mySheduledUpdates.isEmpty()) {
                this.restartTimer();
            }
            this.put(update);
        }
    }

    private boolean eatThisOrOthers(Update update) {
        Update[] updates;
        if (this.mySheduledUpdates.contains(update)) {
            return false;
        }
        for (Update eachInQueue : updates = this.mySheduledUpdates.toArray(new Update[this.mySheduledUpdates.size()])) {
            if (eachInQueue.canEat(update)) {
                return true;
            }
            if (!update.canEat(eachInQueue)) continue;
            this.mySheduledUpdates.remove(eachInQueue);
        }
        return false;
    }

    public final void run(Update update) {
        this.execute(new Update[]{update});
    }

    private void put(Update update) {
        this.mySheduledUpdates.remove(update);
        this.mySheduledUpdates.add(update);
    }

    protected static boolean passThroughForUnitTesting() {
        return true;
    }

    public boolean isActive() {
        return this.myActive;
    }

    public void dispose() {
        this.myDisposed = true;
        this.myActive = false;
        this.clearWaiter();
    }

    private void clearWaiter() {
        this.myWaiterForMerge.cancelAllRequests();
    }

    public String toString() {
        return "Merger: " + this.myName + " active=" + this.myActive + " sheduled=" + this.mySheduledUpdates;
    }

    public ModalityState getModalityState() {
        if (this.myComponent == null) {
            return ModalityState.NON_MODAL;
        }
        return ModalityState.stateForComponent(this.myComponent);
    }
}

