/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.ui.update;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.ui.update.Activatable;
import com.intellij.util.ui.update.UiNotifyConnector;
import java.awt.Window;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JRootPane;
import javax.swing.JWindow;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ComponentDisposable
implements Disposable {
    private JComponent myComponent;
    private JRootPane myRoot;

    public ComponentDisposable(@NotNull JComponent c, @Nullable Project project) {
        if (c == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/ui/update/ComponentDisposable.<init> must not be null");
        }
        this.myComponent = c;
        new UiNotifyConnector(c, new Activatable(){

            public void showNotify() {
                ComponentDisposable.this.atttach();
            }

            public void hideNotify() {
            }
        });
        if (project != null) {
            Disposer.register(project, this);
        } else {
            Disposer.register(Disposer.get("ui"), this);
        }
    }

    private void atttach() {
        if (this.myRoot != null) {
            return;
        }
        Window w = SwingUtilities.getWindowAncestor(this.myComponent);
        JRootPane root = null;
        if (w instanceof JFrame) {
            root = ((JFrame)w).getRootPane();
        } else if (w instanceof JWindow) {
            root = ((JWindow)w).getRootPane();
        } else if (w instanceof JDialog) {
            root = ((JDialog)w).getRootPane();
        }
        if (root != null) {
            this.myRoot = root;
            UiNotifyConnector.Once rootNotify = new UiNotifyConnector.Once(this.myRoot, new Activatable(){

                public void showNotify() {
                }

                public void hideNotify() {
                }
            });
            Disposer.register(rootNotify, this);
        }
    }

    public void dispose() {
    }
}

