/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.ui.treetable;

import com.intellij.util.ui.Table;
import com.intellij.util.ui.treetable.TreeTableModel;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.tree.TreePath;

public class TreeTableModelAdapter
extends AbstractTableModel {
    JTree tree;
    TreeTableModel treeTableModel;
    private final Table table;

    public TreeTableModelAdapter(TreeTableModel treeTableModel, JTree tree, Table table) {
        this.tree = tree;
        this.treeTableModel = treeTableModel;
        this.table = table;
        tree.addTreeExpansionListener(new TreeExpansionListener(){

            public void treeExpanded(TreeExpansionEvent event) {
                TreeTableModelAdapter.this.fireTableDataChanged();
            }

            public void treeCollapsed(TreeExpansionEvent event) {
                TreeTableModelAdapter.this.fireTableDataChanged();
            }
        });
        treeTableModel.addTreeModelListener(new TreeModelListener(){

            public void treeNodesChanged(TreeModelEvent e) {
                TreeTableModelAdapter.this.delayedFireTableDataChanged();
            }

            public void treeNodesInserted(TreeModelEvent e) {
                TreeTableModelAdapter.this.delayedFireTableDataChanged();
            }

            public void treeNodesRemoved(TreeModelEvent e) {
                TreeTableModelAdapter.this.delayedFireTableDataChanged();
            }

            public void treeStructureChanged(TreeModelEvent e) {
                TreeTableModelAdapter.this.delayedFireTableDataChanged();
            }
        });
    }

    public int getColumnCount() {
        return this.treeTableModel.getColumnCount();
    }

    public String getColumnName(int column) {
        return this.treeTableModel.getColumnName(column);
    }

    public Class getColumnClass(int column) {
        return this.treeTableModel.getColumnClass(column);
    }

    public int getRowCount() {
        return this.tree.getRowCount();
    }

    protected Object nodeForRow(int row) {
        TreePath treePath = this.tree.getPathForRow(row);
        return treePath == null ? null : treePath.getLastPathComponent();
    }

    public Object getValueAt(int row, int column) {
        Object o = this.nodeForRow(row);
        return o == null ? null : this.treeTableModel.getValueAt(o, column);
    }

    public boolean isCellEditable(int row, int column) {
        Object o = this.nodeForRow(row);
        return o == null ? false : this.treeTableModel.isCellEditable(o, column);
    }

    public void setValueAt(Object value, int row, int column) {
        Object o = this.nodeForRow(row);
        if (o != null) {
            this.treeTableModel.setValueAt(value, o, column);
        }
    }

    protected void delayedFireTableDataChanged() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                TreeTableModelAdapter.this.fireTableDataChanged();
            }
        });
    }

    public void fireTableDataChanged() {
        TreePath[] treePaths = this.tree.getSelectionPaths();
        super.fireTableDataChanged();
        if (treePaths != null) {
            for (TreePath treePath : treePaths) {
                int row = this.tree.getRowForPath(treePath);
                this.table.getSelectionModel().addSelectionInterval(row, row);
            }
        }
    }
}

