/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.ui.treetable;

import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.treetable.TreeTable;
import com.intellij.util.ui.treetable.TreeTableModel;
import com.intellij.util.ui.treetable.TreeTableTree;
import java.awt.Component;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.border.Border;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import javax.swing.tree.TreeCellRenderer;

public class TreeTableCellRenderer
implements TableCellRenderer {
    private final TreeTable myTreeTable;
    private final TreeTableTree myTree;
    private TreeCellRenderer myTreeCellRenderer;
    private Border myDefaultBorder = UIUtil.getTableFocusCellHighlightBorder();

    public TreeTableCellRenderer(TreeTable treeTable, TreeTableTree tree) {
        this.myTreeTable = treeTable;
        this.myTree = tree;
    }

    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        if (this.myTreeCellRenderer != null) {
            this.myTree.setCellRenderer(this.myTreeCellRenderer);
        }
        if (isSelected) {
            this.myTree.setBackground(table.getSelectionBackground());
            this.myTree.setForeground(table.getSelectionForeground());
        } else {
            this.myTree.setBackground(table.getBackground());
            this.myTree.setForeground(table.getForeground());
        }
        TableModel model = this.myTreeTable.getModel();
        this.myTree.setTreeTableTreeBorder(hasFocus && model.getColumnClass(column).equals(TreeTableModel.class) ? this.myDefaultBorder : null);
        this.myTree.setVisibleRow(row);
        Object treeObject = this.myTree.getPathForRow(row).getLastPathComponent();
        boolean leaf = this.myTree.getModel().isLeaf(treeObject);
        boolean expanded = this.myTree.isExpanded(row);
        Component component = this.myTree.getCellRenderer().getTreeCellRendererComponent(this.myTree, treeObject, isSelected, expanded, leaf, row, hasFocus);
        if (component instanceof JComponent) {
            table.setToolTipText(((JComponent)component).getToolTipText());
        }
        this.myTree.setCellFocused(hasFocus);
        return this.myTree;
    }

    public void setCellRenderer(TreeCellRenderer treeCellRenderer) {
        this.myTreeCellRenderer = treeCellRenderer;
    }

    public void setDefaultBorder(Border border) {
        this.myDefaultBorder = border;
    }

    public void putClientProperty(String s, String s1) {
        this.myTree.putClientProperty(s, s1);
    }

    public void setRootVisible(boolean b) {
        this.myTree.setRootVisible(b);
    }

    public void setShowsRootHandles(boolean b) {
        this.myTree.setShowsRootHandles(b);
    }
}

