/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.ui.treetable;

import com.intellij.util.ui.Table;
import com.intellij.util.ui.treetable.TreeTableCellEditor;
import com.intellij.util.ui.treetable.TreeTableCellRenderer;
import com.intellij.util.ui.treetable.TreeTableModel;
import com.intellij.util.ui.treetable.TreeTableModelAdapter;
import com.intellij.util.ui.treetable.TreeTableTree;
import java.awt.Dimension;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.EventObject;
import java.util.HashSet;
import java.util.Iterator;
import javax.swing.ListSelectionModel;
import javax.swing.LookAndFeel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.tree.DefaultTreeSelectionModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreePath;

public class TreeTable
extends Table {
    private TreeTableTree myTree;
    private TreeTableModel myTableModel;
    private PropertyChangeListener myTreeRowHeightPropertyListener;

    public TreeTable(TreeTableModel treeTableModel) {
        this.setModel(treeTableModel);
    }

    public void setModel(TreeTableModel treeTableModel) {
        if (this.myTree != null) {
            this.myTree.removePropertyChangeListener("rowHeight", this.myTreeRowHeightPropertyListener);
        }
        this.myTree = new TreeTableTree(treeTableModel, this);
        if (this.myTree.getRowHeight() != this.getRowHeight()) {
            this.setRowHeight(this.myTree.getRowHeight());
        }
        this.myTreeRowHeightPropertyListener = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                int treeRowHeight = TreeTable.this.myTree.getRowHeight();
                if (treeRowHeight == TreeTable.this.getRowHeight() - 3) {
                    return;
                }
                TreeTable.this.setRowHeight(treeRowHeight);
            }
        };
        this.myTree.addPropertyChangeListener("rowHeight", this.myTreeRowHeightPropertyListener);
        this.setTableModel(treeTableModel);
        ListToTreeSelectionModelWrapper selectionWrapper = new ListToTreeSelectionModelWrapper();
        this.myTree.setSelectionModel(selectionWrapper);
        this.setSelectionModel(selectionWrapper.getListSelectionModel());
        TreeTableCellRenderer treeTableCellRenderer = this.createTableRenderer(treeTableModel);
        this.setDefaultRenderer(TreeTableModel.class, treeTableCellRenderer);
        this.setDefaultEditor(TreeTableModel.class, new TreeTableCellEditor(treeTableCellRenderer));
        this.setShowGrid(false);
        this.setIntercellSpacing(new Dimension(0, 0));
        if (this.myTree.getRowHeight() < 1) {
            this.setRowHeight(18);
        }
        this.setRowHeight(this.getRowHeight());
    }

    public TreeTableModel getTableModel() {
        return this.myTableModel;
    }

    public void setTableModel(TreeTableModel treeTableModel) {
        this.myTableModel = treeTableModel;
        super.setModel(new TreeTableModelAdapter(treeTableModel, this.myTree, this));
    }

    public void setRootVisible(boolean visible) {
        this.myTree.setRootVisible(visible);
    }

    public void putTreeClientProperty(Object key, Object value) {
        this.myTree.putClientProperty(key, value);
    }

    public void setTreeCellRenderer(TreeCellRenderer renderer) {
        this.myTree.setCellRenderer(renderer);
    }

    public void updateUI() {
        super.updateUI();
        if (this.myTree != null) {
            this.myTree.updateUI();
        }
        LookAndFeel.installColorsAndFont(this, "Tree.background", "Tree.foreground", "Tree.font");
    }

    public int getEditingRow() {
        return this.isTreeColumn(this.editingColumn) ? -1 : this.editingRow;
    }

    public void setRowHeight(int rowHeight) {
        super.setRowHeight(rowHeight);
        if (this.myTree != null && this.myTree.getRowHeight() < rowHeight) {
            this.myTree.setRowHeight(this.getRowHeight() - 3);
        }
    }

    public TreeTableTree getTree() {
        return this.myTree;
    }

    protected void processKeyEvent(KeyEvent e) {
        boolean oneRowSelected;
        int keyCode = e.getKeyCode();
        int selColumn = this.columnModel.getSelectionModel().getAnchorSelectionIndex();
        boolean treeHasFocus = selColumn >= 0 && this.isTreeColumn(selColumn);
        boolean bl = oneRowSelected = this.getSelectedRowCount() == 1;
        if (treeHasFocus && oneRowSelected && (keyCode == 37 || keyCode == 39)) {
            TreePath selectionPath = this.myTree.getSelectionPath();
            this.myTree._processKeyEvent(e);
            this.myTree.setSelectionPath(selectionPath);
        } else {
            super.processKeyEvent(e);
        }
    }

    public boolean editCellAt(int row, int column, EventObject e) {
        boolean editResult = super.editCellAt(row, column, e);
        if (e instanceof MouseEvent && this.isTreeColumn(column)) {
            MouseEvent me = (MouseEvent)e;
            MouseEvent newEvent = new MouseEvent(this.myTree, me.getID(), me.getWhen(), me.getModifiers(), me.getX() - this.getCellRect((int)0, (int)column, (boolean)true).x, me.getY(), me.getClickCount(), me.isPopupTrigger());
            this.myTree.dispatchEvent(newEvent);
            if (newEvent.getID() == 501) {
                MouseEvent newME2 = new MouseEvent(this.myTree, 502, me.getWhen(), me.getModifiers(), me.getX() - this.getCellRect((int)0, (int)column, (boolean)true).x, me.getY() - this.getCellRect((int)0, (int)column, (boolean)true).y, me.getClickCount(), me.isPopupTrigger());
                this.myTree.dispatchEvent(newME2);
            }
        }
        return editResult;
    }

    private boolean isTreeColumn(int column) {
        return TreeTableModel.class.isAssignableFrom(this.getColumnClass(column));
    }

    public void addSelectedPath(TreePath path) {
        int row = this.getTree().getRowForPath(path);
        this.getTree().addSelectionPath(path);
        this.getSelectionModel().addSelectionInterval(row, row);
    }

    public void removeSelectedPath(TreePath path) {
        int row = this.getTree().getRowForPath(path);
        this.getTree().removeSelectionPath(path);
        this.getSelectionModel().removeSelectionInterval(row, row);
    }

    public TreeTableCellRenderer createTableRenderer(TreeTableModel treeTableModel) {
        return new TreeTableCellRenderer(this, this.myTree);
    }

    public void setMinRowHeight(int i) {
        this.setRowHeight(Math.max(this.getRowHeight(), i));
    }

    private class ListToTreeSelectionModelWrapper
    extends DefaultTreeSelectionModel {
        protected boolean updatingListSelectionModel;

        public ListToTreeSelectionModelWrapper() {
            this.getListSelectionModel().addListSelectionListener(this.createListSelectionListener());
        }

        ListSelectionModel getListSelectionModel() {
            return this.listSelectionModel;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void resetRowSelection() {
            if (!this.updatingListSelectionModel) {
                this.updatingListSelectionModel = true;
                try {
                    HashSet<Integer> selectedRows = new HashSet<Integer>();
                    int min = this.listSelectionModel.getMinSelectionIndex();
                    int max = this.listSelectionModel.getMaxSelectionIndex();
                    if (min != -1 && max != -1) {
                        for (int counter = min; counter <= max; ++counter) {
                            if (!this.listSelectionModel.isSelectedIndex(counter)) continue;
                            selectedRows.add(new Integer(counter));
                        }
                    }
                    super.resetRowSelection();
                    this.listSelectionModel.clearSelection();
                    Iterator i$ = selectedRows.iterator();
                    while (i$.hasNext()) {
                        Integer selectedRow;
                        Integer row = selectedRow = (Integer)i$.next();
                        this.listSelectionModel.addSelectionInterval(row, row);
                    }
                }
                finally {
                    this.updatingListSelectionModel = false;
                }
            }
        }

        protected ListSelectionListener createListSelectionListener() {
            return new ListSelectionHandler();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void updateSelectedPathsFromSelectedRows() {
            if (!this.updatingListSelectionModel) {
                this.updatingListSelectionModel = true;
                try {
                    int min = this.listSelectionModel.getMinSelectionIndex();
                    int max = this.listSelectionModel.getMaxSelectionIndex();
                    this.clearSelection();
                    if (min != -1 && max != -1) {
                        for (int counter = min; counter <= max; ++counter) {
                            TreePath selPath;
                            if (!this.listSelectionModel.isSelectedIndex(counter) || (selPath = TreeTable.this.myTree.getPathForRow(counter)) == null) continue;
                            this.addSelectionPath(selPath);
                        }
                    }
                }
                finally {
                    this.updatingListSelectionModel = false;
                }
            }
        }

        class ListSelectionHandler
        implements ListSelectionListener {
            ListSelectionHandler() {
            }

            public void valueChanged(ListSelectionEvent e) {
                ListToTreeSelectionModelWrapper.this.updateSelectedPathsFromSelectedRows();
            }
        }
    }
}

