/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.ui.treetable;

import com.intellij.util.ui.ColumnInfo;
import com.intellij.util.ui.treetable.TreeTableModel;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;

public class ListTreeTableModel
extends DefaultTreeModel
implements TreeTableModel {
    private final ColumnInfo[] myColumns;

    public ListTreeTableModel(TreeNode root, ColumnInfo[] columns) {
        super(root);
        this.myColumns = columns;
    }

    public int getColumnCount() {
        return this.myColumns.length;
    }

    public String getColumnName(int column) {
        return this.myColumns[column].getName();
    }

    public Object getValueAt(Object node, int column) {
        return this.myColumns[column].valueOf(node);
    }

    public int getChildCount(Object parent) {
        return ((TreeNode)parent).getChildCount();
    }

    public Object getChild(Object parent, int index) {
        return ((TreeNode)parent).getChildAt(index);
    }

    public Class getColumnClass(int column) {
        return this.myColumns[column].getColumnClass();
    }

    public boolean isCellEditable(Object node, int column) {
        return this.myColumns[column].isCellEditable(node);
    }

    public void setValueAt(Object aValue, Object node, int column) {
        this.myColumns[column].setValue(node, aValue);
    }
}

