/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.ui.tree;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.Comparing;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.util.Range;
import com.intellij.util.ui.tree.IndexTreePathState;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.plaf.basic.BasicTreeUI;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class TreeUtil {
    private static final Logger LOG = Logger.getInstance("#com.intellij.util.ui.tree.TreeUtil");

    private TreeUtil() {
    }

    public static void collectExpandedPaths(JTree tree, List<TreePath> paths) {
        LOG.assertTrue(tree != null);
        LOG.assertTrue(paths != null);
        TreeModel model = tree.getModel();
        Object root = model.getRoot();
        LOG.assertTrue(root != null);
        TreeUtil.collectExpandedPathsImpl(tree, paths, new TreePath(root));
    }

    public static List<TreePath> collectExpandedPaths(@NotNull JTree tree) {
        if (tree == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/ui/tree/TreeUtil.collectExpandedPaths must not be null");
        }
        ArrayList<TreePath> result = new ArrayList<TreePath>();
        Object root = tree.getModel().getRoot();
        TreePath rootPath = new TreePath(root);
        result.addAll(TreeUtil.collectExpandedPaths(tree, rootPath));
        return result;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static <T> List<T> collectSelectedObjectsOfType(JTree tree, Class<T> clazz) {
        List list;
        TreePath[] selections = tree.getSelectionPaths();
        if (selections != null) {
            ArrayList result = new ArrayList();
            for (TreePath selection : selections) {
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)selection.getLastPathComponent();
                Object userObject = node.getUserObject();
                if (!clazz.isInstance(userObject)) continue;
                result.add(userObject);
            }
            list = result;
            if (list == null) throw new IllegalStateException("@NotNull method com/intellij/util/ui/tree/TreeUtil.collectSelectedObjectsOfType must not return null");
            return list;
        }
        list = Collections.emptyList();
        if (list != null) return list;
        throw new IllegalStateException("@NotNull method com/intellij/util/ui/tree/TreeUtil.collectSelectedObjectsOfType must not return null");
    }

    public static List<TreePath> collectExpandedPaths(JTree tree, TreePath path) {
        ArrayList<TreePath> result = new ArrayList<TreePath>();
        if (!tree.isExpanded(path)) {
            return result;
        }
        Object lastPathComponent = path.getLastPathComponent();
        TreeModel model = tree.getModel();
        if (model.isLeaf(lastPathComponent)) {
            result.add(path);
        } else {
            boolean pathWasAdded = false;
            for (int i = model.getChildCount(lastPathComponent) - 1; i >= 0; --i) {
                TreePath childPath = path.pathByAddingChild(model.getChild(lastPathComponent, i));
                if (model.isLeaf(lastPathComponent)) {
                    if (pathWasAdded) continue;
                    result.add(path);
                    pathWasAdded = true;
                    continue;
                }
                if (tree.isExpanded(childPath)) {
                    result.addAll(TreeUtil.collectExpandedPaths(tree, childPath));
                    continue;
                }
                if (pathWasAdded) continue;
                result.add(path);
                pathWasAdded = true;
            }
        }
        return result;
    }

    private static boolean collectExpandedPathsImpl(JTree tree, Collection<TreePath> paths, TreePath path) {
        Object lastPathComponent;
        TreeModel model = tree.getModel();
        if (model.isLeaf(lastPathComponent = path.getLastPathComponent())) {
            return false;
        }
        boolean hasExpandedChildren = false;
        for (int i = model.getChildCount(lastPathComponent) - 1; i >= 0; --i) {
            hasExpandedChildren |= TreeUtil.collectExpandedPathsImpl(tree, paths, path.pathByAddingChild(model.getChild(lastPathComponent, i)));
        }
        if (!hasExpandedChildren) {
            paths.add(path);
            return true;
        }
        return false;
    }

    public static void restoreExpandedPaths(JTree tree, List<TreePath> paths) {
        LOG.assertTrue(tree != null);
        LOG.assertTrue(paths != null);
        for (int i = paths.size() - 1; i >= 0; --i) {
            tree.expandPath(paths.get(i));
        }
    }

    public static TreePath getPath(TreeNode aRootNode, TreeNode aNode) {
        ArrayList<TreeNode> pathStack = new ArrayList<TreeNode>();
        TreeUtil.addEach(aRootNode, aNode, pathStack);
        Object[] pathElements = new Object[pathStack.size()];
        for (int i = pathStack.size() - 1; i >= 0; --i) {
            pathElements[pathStack.size() - i - 1] = pathStack.get(i);
        }
        return new TreePath(pathElements);
    }

    public static boolean isAncestor(TreeNode ancestor, TreeNode node) {
        for (TreeNode parent = node; parent != null; parent = parent.getParent()) {
            if (parent != ancestor) continue;
            return true;
        }
        return false;
    }

    private static boolean isAncestor(TreePath ancestor, TreePath path) {
        if (path.getPathCount() < ancestor.getPathCount()) {
            return false;
        }
        for (int i = 0; i < ancestor.getPathCount(); ++i) {
            if (path.getPathComponent(i).equals(ancestor.getPathComponent(i))) continue;
            return false;
        }
        return true;
    }

    private static boolean isDescendants(TreePath path, TreePath[] paths) {
        for (TreePath ancestor : paths) {
            if (!TreeUtil.isAncestor(ancestor, path)) continue;
            return true;
        }
        return false;
    }

    public static TreePath getPathFromRoot(TreeNode node) {
        ArrayList<TreeNode> path = new ArrayList<TreeNode>();
        do {
            path.add(node);
        } while ((node = node.getParent()) != null);
        Collections.reverse(path);
        return new TreePath(path.toArray());
    }

    @Nullable
    public static TreeNode findNodeWithObject(Object object, TreeModel model, Object parent) {
        for (int i = 0; i < model.getChildCount(parent); ++i) {
            DefaultMutableTreeNode childNode = (DefaultMutableTreeNode)model.getChild(parent, i);
            if (!childNode.getUserObject().equals(object)) continue;
            return childNode;
        }
        return null;
    }

    public static void removeSelected(JTree tree) {
        LOG.assertTrue(tree != null);
        TreePath selectionPath = tree.getSelectionPath();
        if (selectionPath == null) {
            return;
        }
        TreeUtil.removeLastPathComponent((DefaultTreeModel)tree.getModel(), selectionPath).restoreSelection(tree);
    }

    public static void removeLastPathComponent(JTree tree, TreePath pathToBeRemoved) {
        LOG.assertTrue(tree != null);
        LOG.assertTrue(pathToBeRemoved != null);
        TreeUtil.removeLastPathComponent((DefaultTreeModel)tree.getModel(), pathToBeRemoved).restoreSelection(tree);
    }

    @Nullable
    public static DefaultMutableTreeNode findNodeWithObject(DefaultMutableTreeNode aRoot, Object aObject) {
        if (Comparing.equal(aRoot.getUserObject(), aObject)) {
            return aRoot;
        }
        for (int i = 0; i < aRoot.getChildCount(); ++i) {
            DefaultMutableTreeNode candidate = TreeUtil.findNodeWithObject((DefaultMutableTreeNode)aRoot.getChildAt(i), aObject);
            if (null == candidate) continue;
            return candidate;
        }
        return null;
    }

    public static TreePath findCommonPath(TreePath[] treePaths) {
        LOG.assertTrue(TreeUtil.areComponentsEqual(treePaths, 0));
        TreePath result = new TreePath(treePaths[0].getPathComponent(0));
        int pathIndex = 1;
        while (TreeUtil.areComponentsEqual(treePaths, pathIndex)) {
            result = result.pathByAddingChild(treePaths[0].getPathComponent(pathIndex));
            ++pathIndex;
        }
        return result;
    }

    public static ActionCallback selectFirstNode(JTree tree) {
        TreeModel model = tree.getModel();
        Object root = model.getRoot();
        TreePath selectionPath = new TreePath(root);
        if (!tree.isRootVisible() && model.getChildCount(root) > 0) {
            selectionPath = selectionPath.pathByAddingChild(model.getChild(root, 0));
        }
        return TreeUtil.selectPath(tree, selectionPath);
    }

    private static void addEach(TreeNode aRootNode, TreeNode aNode, List<TreeNode> aPathStack) {
        aPathStack.add(aNode);
        if (aNode != aRootNode) {
            TreeUtil.addEach(aRootNode, aNode.getParent(), aPathStack);
        }
    }

    private static IndexTreePathState removeLastPathComponent(DefaultTreeModel model, TreePath pathToBeRemoved) {
        IndexTreePathState selectionState = new IndexTreePathState(pathToBeRemoved);
        if (((MutableTreeNode)pathToBeRemoved.getLastPathComponent()).getParent() == null) {
            return selectionState;
        }
        model.removeNodeFromParent((MutableTreeNode)pathToBeRemoved.getLastPathComponent());
        return selectionState;
    }

    private static boolean areComponentsEqual(TreePath[] paths, int componentIndex) {
        if (paths[0].getPathCount() <= componentIndex) {
            return false;
        }
        Object pathComponent = paths[0].getPathComponent(componentIndex);
        for (TreePath treePath : paths) {
            if (treePath.getPathCount() <= componentIndex) {
                return false;
            }
            if (pathComponent.equals(treePath.getPathComponent(componentIndex))) continue;
            return false;
        }
        return true;
    }

    private static TreePath[] removeDuplicates(TreePath[] paths) {
        ArrayList<TreePath> result = new ArrayList<TreePath>();
        for (TreePath path : paths) {
            if (result.contains(path)) continue;
            result.add(path);
        }
        return result.toArray(new TreePath[result.size()]);
    }

    public static TreePath[] selectMaximals(TreePath[] paths) {
        if (paths == null) {
            return new TreePath[0];
        }
        TreePath[] noDuplicates = TreeUtil.removeDuplicates(paths);
        ArrayList<TreePath> result = new ArrayList<TreePath>();
        for (TreePath path : noDuplicates) {
            ArrayList<TreePath> otherPaths = new ArrayList<TreePath>(Arrays.asList(noDuplicates));
            otherPaths.remove(path);
            if (TreeUtil.isDescendants(path, otherPaths.toArray(new TreePath[otherPaths.size()]))) continue;
            result.add(path);
        }
        return result.toArray(new TreePath[result.size()]);
    }

    public static void sort(DefaultTreeModel model, Comparator comparator) {
        TreeUtil.sort((DefaultMutableTreeNode)model.getRoot(), comparator);
    }

    public static void sort(DefaultMutableTreeNode node, Comparator comparator) {
        ArrayList<TreeNode> children = TreeUtil.childrenToArray(node);
        Collections.sort(children, comparator);
        node.removeAllChildren();
        TreeUtil.addChildrenTo(node, children);
        for (int i = 0; i < node.getChildCount(); ++i) {
            TreeUtil.sort((DefaultMutableTreeNode)node.getChildAt(i), comparator);
        }
    }

    private static void addChildrenTo(MutableTreeNode node, List<TreeNode> children) {
        for (TreeNode aChildren : children) {
            MutableTreeNode child = (MutableTreeNode)aChildren;
            node.insert(child, node.getChildCount());
        }
    }

    public static boolean traverse(TreeNode node, Traverse traverse) {
        int childCount = node.getChildCount();
        for (int i = 0; i < childCount; ++i) {
            if (TreeUtil.traverse(node.getChildAt(i), traverse)) continue;
            return false;
        }
        return traverse.accept(node);
    }

    public static boolean traverseDepth(TreeNode node, Traverse traverse) {
        if (!traverse.accept(node)) {
            return false;
        }
        int childCount = node.getChildCount();
        for (int i = 0; i < childCount; ++i) {
            if (TreeUtil.traverseDepth(node.getChildAt(i), traverse)) continue;
            return false;
        }
        return true;
    }

    public static ActionCallback selectPath(JTree tree, TreePath path) {
        return TreeUtil.selectPath(tree, path, true);
    }

    public static ActionCallback selectPath(JTree tree, TreePath path, boolean center) {
        tree.makeVisible(path);
        if (center) {
            return TreeUtil.showRowCentred(tree, tree.getRowForPath(path));
        }
        int row = tree.getRowForPath(path);
        return TreeUtil.showAndSelect(tree, row - 2, row + 2, row, -1);
    }

    private static ActionCallback moveDown(JTree tree) {
        int size = tree.getRowCount();
        int row = TreeUtil.getSelectedRow(tree);
        if (row < size - 1) {
            return TreeUtil.showAndSelect(tree, ++row, row + 2, row, TreeUtil.getSelectedRow(tree));
        }
        return new ActionCallback.Done();
    }

    private static ActionCallback moveUp(JTree tree) {
        int row = TreeUtil.getSelectedRow(tree);
        if (row > 0) {
            return TreeUtil.showAndSelect(tree, --row - 2, row, row, TreeUtil.getSelectedRow(tree));
        }
        return new ActionCallback.Done();
    }

    private static ActionCallback movePageUp(JTree tree) {
        int visible = TreeUtil.getVisibleRowCount(tree);
        if (visible <= 0) {
            return TreeUtil.moveHome(tree);
        }
        int decrement = visible - 1;
        int row = Math.max(TreeUtil.getSelectedRow(tree) - decrement, 0);
        int top = TreeUtil.getFirstVisibleRow(tree) - decrement;
        int bottom = top + visible - 1;
        return TreeUtil.showAndSelect(tree, top, bottom, row, TreeUtil.getSelectedRow(tree));
    }

    private static ActionCallback movePageDown(JTree tree) {
        int visible = TreeUtil.getVisibleRowCount(tree);
        if (visible <= 0) {
            return TreeUtil.moveEnd(tree);
        }
        int size = tree.getRowCount();
        int increment = visible - 1;
        int index = Math.min(TreeUtil.getSelectedRow(tree) + increment, size - 1);
        int top = TreeUtil.getFirstVisibleRow(tree) + increment;
        int bottom = top + visible - 1;
        return TreeUtil.showAndSelect(tree, top, bottom, index, TreeUtil.getSelectedRow(tree));
    }

    private static ActionCallback moveHome(JTree tree) {
        return TreeUtil.showRowCentred(tree, 0);
    }

    private static ActionCallback moveEnd(JTree tree) {
        return TreeUtil.showRowCentred(tree, tree.getRowCount() - 1);
    }

    private static ActionCallback showRowCentred(JTree tree, int row) {
        return TreeUtil.showRowCentered(tree, row, true);
    }

    public static ActionCallback showRowCentered(JTree tree, int row, boolean centerHorizontally) {
        int visible = TreeUtil.getVisibleRowCount(tree);
        int top = visible > 0 ? row - (visible - 1) / 2 : row;
        int bottom = visible > 0 ? top + visible - 1 : row;
        return TreeUtil.showAndSelect(tree, top, bottom, row, -1);
    }

    public static ActionCallback showAndSelect(JTree tree, int top, int bottom, int row, int previous) {
        return TreeUtil.showAndSelect(tree, top, bottom, row, previous, false);
    }

    public static ActionCallback showAndSelect(final JTree tree, int top, int bottom, int row, int previous, boolean addToSelection) {
        Rectangle bottomBounds;
        Rectangle rowBounds;
        TreePath path = tree.getPathForRow(row);
        if (path == null) {
            return new ActionCallback.Done();
        }
        int size = tree.getRowCount();
        if (size == 0) {
            tree.clearSelection();
            return new ActionCallback.Done();
        }
        if (top < 0) {
            top = 0;
        }
        if (bottom >= size) {
            bottom = size - 1;
        }
        if (row >= tree.getRowCount()) {
            return new ActionCallback.Done();
        }
        if (!tree.isValid()) {
            tree.validate();
        }
        if ((rowBounds = tree.getRowBounds(row)) == null) {
            return new ActionCallback.Done();
        }
        Rectangle topBounds = tree.getRowBounds(top);
        if (topBounds == null) {
            topBounds = rowBounds;
        }
        if ((bottomBounds = tree.getRowBounds(bottom)) == null) {
            bottomBounds = rowBounds;
        }
        Rectangle bounds = topBounds.union(bottomBounds);
        bounds.x = rowBounds.x;
        bounds.width = rowBounds.width;
        Rectangle visible = tree.getVisibleRect();
        if (visible.contains(bounds)) {
            bounds = null;
        } else {
            Component comp = tree.getCellRenderer().getTreeCellRendererComponent(tree, path.getLastPathComponent(), true, true, false, row, false);
            if (comp instanceof SimpleColoredComponent) {
                SimpleColoredComponent renderer = (SimpleColoredComponent)comp;
                Dimension scrollableSize = renderer.computePreferredSize(true);
                bounds.width = scrollableSize.width;
            }
        }
        final ActionCallback callback = new ActionCallback();
        if (!tree.isRowSelected(row)) {
            if (addToSelection) {
                tree.getSelectionModel().addSelectionPath(tree.getPathForRow(row));
            } else {
                tree.setSelectionRow(row);
            }
        }
        if (bounds != null) {
            Range<Integer> range = TreeUtil.getExpandControlRange(tree, path);
            if (range != null) {
                int delta = bounds.x - range.getFrom();
                bounds.x -= delta;
                bounds.width -= delta;
            }
            if (visible.width < bounds.width) {
                bounds.width = visible.width;
            }
            final Rectangle b1 = bounds;
            Runnable runnable = new Runnable(){

                public void run() {
                    tree.scrollRectToVisible(b1);
                    callback.setDone();
                }
            };
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                runnable.run();
            } else {
                SwingUtilities.invokeLater(runnable);
            }
        } else {
            callback.setDone();
        }
        return callback;
    }

    private static int getSelectedRow(JTree tree) {
        return tree.getRowForPath(tree.getSelectionPath());
    }

    private static int getFirstVisibleRow(JTree tree) {
        Rectangle visible = tree.getVisibleRect();
        int row = -1;
        for (int i = 0; i < tree.getRowCount(); ++i) {
            Rectangle bounds = tree.getRowBounds(i);
            if (visible.y > bounds.y || visible.y + visible.height < bounds.y + bounds.height) continue;
            row = i;
            break;
        }
        return row;
    }

    private static int getVisibleRowCount(JTree tree) {
        Rectangle visible = tree.getVisibleRect();
        int count = 0;
        for (int i = 0; i < tree.getRowCount(); ++i) {
            Rectangle bounds = tree.getRowBounds(i);
            if (visible.y > bounds.y || visible.y + visible.height < bounds.y + bounds.height) continue;
            ++count;
        }
        return count;
    }

    public static void installActions(final JTree tree) {
        tree.getActionMap().put("scrollUpChangeSelection", new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                TreeUtil.movePageUp(tree);
            }
        });
        tree.getActionMap().put("scrollDownChangeSelection", new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                TreeUtil.movePageDown(tree);
            }
        });
        tree.getActionMap().put("selectPrevious", new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                TreeUtil.moveUp(tree);
            }
        });
        tree.getActionMap().put("selectNext", new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                TreeUtil.moveDown(tree);
            }
        });
        TreeUtil.copyAction(tree, "selectLast", "selectLastChangeLead");
        TreeUtil.copyAction(tree, "selectFirst", "selectFirstChangeLead");
    }

    private static void copyAction(JTree tree, String original, String copyTo) {
        Action action = tree.getActionMap().get(original);
        if (action != null) {
            tree.getActionMap().put(copyTo, action);
        }
    }

    public static void collapseAll(JTree tree, int keepSelectionLevel) {
        TreePath leadSelectionPath = tree.getLeadSelectionPath();
        for (int row = tree.getRowCount() - 1; row >= 0; --row) {
            tree.collapseRow(row);
        }
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)tree.getModel().getRoot();
        tree.expandPath(new TreePath(root));
        if (leadSelectionPath != null) {
            Object[] path = leadSelectionPath.getPath();
            Object[] pathToSelect = new Object[path.length > keepSelectionLevel && keepSelectionLevel >= 0 ? keepSelectionLevel : path.length];
            System.arraycopy(path, 0, pathToSelect, 0, pathToSelect.length);
            if (pathToSelect.length == 0) {
                return;
            }
            TreeUtil.selectPath(tree, new TreePath(pathToSelect));
        }
    }

    public static void selectNode(JTree tree, TreeNode node) {
        TreeUtil.selectPath(tree, TreeUtil.getPathFromRoot(node));
    }

    public static void moveSelectedRow(JTree tree, int direction) {
        TreePath selectionPath = tree.getSelectionPath();
        DefaultMutableTreeNode treeNode = (DefaultMutableTreeNode)selectionPath.getLastPathComponent();
        DefaultMutableTreeNode parent = (DefaultMutableTreeNode)treeNode.getParent();
        int idx = parent.getIndex(treeNode);
        parent.remove(treeNode);
        parent.insert(treeNode, idx + direction);
        ((DefaultTreeModel)tree.getModel()).reload(parent);
        TreeUtil.selectNode(tree, treeNode);
    }

    public static ArrayList<TreeNode> childrenToArray(TreeNode node) {
        ArrayList<TreeNode> result = new ArrayList<TreeNode>();
        for (int i = 0; i < node.getChildCount(); ++i) {
            result.add(node.getChildAt(i));
        }
        return result;
    }

    public static void expandRootChildIfOnlyOne(final JTree tree) {
        if (tree == null) {
            return;
        }
        Runnable runnable = new Runnable(){

            public void run() {
                DefaultMutableTreeNode root = (DefaultMutableTreeNode)tree.getModel().getRoot();
                tree.expandPath(new TreePath(new Object[]{root}));
                if (root.getChildCount() == 1) {
                    TreeNode firstChild = root.getFirstChild();
                    tree.expandPath(new TreePath(new Object[]{root, firstChild}));
                }
            }
        };
        if (EventQueue.isDispatchThread()) {
            runnable.run();
        } else {
            ApplicationManager.getApplication().invokeLater(runnable);
        }
    }

    public static void expandAll(JTree tree) {
        int rowCount;
        tree.expandPath(new TreePath(tree.getModel().getRoot()));
        int oldRowCount = 0;
        while ((rowCount = tree.getRowCount()) != oldRowCount) {
            oldRowCount = rowCount;
            for (int i = 0; i < rowCount; ++i) {
                tree.expandRow(i);
            }
        }
    }

    public static void expand(JTree tree, int levels) {
        TreeUtil.expand(tree, new TreePath(tree.getModel().getRoot()), levels);
    }

    private static void expand(JTree tree, TreePath path, int levels) {
        if (levels == 0) {
            return;
        }
        tree.expandPath(path);
        TreeNode node = (TreeNode)path.getLastPathComponent();
        Enumeration<? extends TreeNode> children = node.children();
        while (children.hasMoreElements()) {
            TreeUtil.expand(tree, path.pathByAddingChild(children.nextElement()), levels - 1);
        }
    }

    public static ActionCallback selectInTree(DefaultMutableTreeNode node, boolean requestFocus, JTree tree) {
        return TreeUtil.selectInTree(node, requestFocus, tree, true);
    }

    public static ActionCallback selectInTree(DefaultMutableTreeNode node, boolean requestFocus, JTree tree, boolean center) {
        if (node == null) {
            return new ActionCallback.Done();
        }
        TreePath treePath = new TreePath(node.getPath());
        tree.expandPath(treePath);
        if (requestFocus) {
            tree.requestFocus();
        }
        return TreeUtil.selectPath(tree, treePath, center);
    }

    public static List<TreePath> collectSelectedPaths(JTree tree, TreePath treePath) {
        ArrayList<TreePath> result = new ArrayList<TreePath>();
        TreePath[] selections = tree.getSelectionPaths();
        if (selections != null) {
            for (TreePath selection : selections) {
                if (!treePath.isDescendant(selection)) continue;
                result.add(selection);
            }
        }
        return result;
    }

    public static void unselect(JTree tree, DefaultMutableTreeNode node) {
        TreePath rootPath = new TreePath(node.getPath());
        TreePath[] selectionPaths = tree.getSelectionPaths();
        if (selectionPaths != null) {
            for (TreePath selectionPath : selectionPaths) {
                if (selectionPath.getPathCount() <= rootPath.getPathCount() || !rootPath.isDescendant(selectionPath)) continue;
                tree.removeSelectionPath(selectionPath);
            }
        }
    }

    @Nullable
    public static Range<Integer> getExpandControlRange(JTree aTree, TreePath path) {
        TreeModel treeModel = aTree.getModel();
        BasicTreeUI basicTreeUI = (BasicTreeUI)aTree.getUI();
        Icon expandedIcon = basicTreeUI.getExpandedIcon();
        Range<Integer> box = null;
        if (path != null && !treeModel.isLeaf(path.getLastPathComponent())) {
            Insets i = aTree.getInsets();
            int boxWidth = expandedIcon != null ? expandedIcon.getIconWidth() : 8;
            int boxLeftX = i != null ? i.left : 0;
            boolean leftToRight = aTree.getComponentOrientation().isLeftToRight();
            int depthOffset = TreeUtil.getDepthOffset(aTree);
            int totalChildIndent = basicTreeUI.getLeftChildIndent() + basicTreeUI.getRightChildIndent();
            if (leftToRight) {
                boxLeftX += (path.getPathCount() + depthOffset - 2) * totalChildIndent + basicTreeUI.getLeftChildIndent() - boxWidth / 2;
            }
            int boxRightX = boxLeftX + boxWidth;
            box = new Range<Integer>(boxLeftX, boxRightX);
        }
        return box;
    }

    public static int getDepthOffset(JTree aTree) {
        if (aTree.isRootVisible()) {
            if (aTree.getShowsRootHandles()) {
                return 1;
            }
            return 0;
        }
        if (!aTree.getShowsRootHandles()) {
            return -1;
        }
        return 0;
    }

    public static interface Traverse {
        public boolean accept(Object var1);
    }
}

