/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.ui;

import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.ui.Tree;
import com.intellij.util.ui.UIUtil;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.util.ArrayList;
import javax.swing.tree.TreeModel;
import org.jetbrains.annotations.Nullable;

public class TreeWithEmptyText
extends Tree {
    private String myEmptyText = "";
    private SimpleColoredComponent myEmptyTextComponent = new SimpleColoredComponent();
    private ArrayList<ActionListener> myEmptyTextClickListeners = new ArrayList();
    private static final int EMPTY_TEXT_TOP = 20;

    public TreeWithEmptyText(TreeModel model) {
        super(model);
        this.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                ActionListener actionListener;
                if (e.getButton() == 1 && e.getClickCount() == 1 && TreeWithEmptyText.this.isModelEmpty() && (actionListener = TreeWithEmptyText.this.findEmptyTextActionListenerAt(e.getPoint())) != null) {
                    actionListener.actionPerformed(new ActionEvent(this, 0, ""));
                }
            }
        });
        this.addMouseMotionListener(new MouseMotionAdapter(){

            public void mouseMoved(MouseEvent e) {
                if (TreeWithEmptyText.this.isModelEmpty()) {
                    if (TreeWithEmptyText.this.findEmptyTextActionListenerAt(e.getPoint()) != null) {
                        TreeWithEmptyText.this.setCursor(Cursor.getPredefinedCursor(12));
                    } else {
                        TreeWithEmptyText.this.setCursor(Cursor.getDefaultCursor());
                    }
                }
            }
        });
        this.myEmptyTextComponent.setFont(UIUtil.getLabelFont());
    }

    @Nullable
    private ActionListener findEmptyTextActionListenerAt(Point point) {
        int index;
        Rectangle bounds = this.getBounds();
        Dimension size = this.myEmptyTextComponent.getPreferredSize();
        int x = (bounds.width - size.width) / 2;
        if (new Rectangle(x, 20, bounds.width, bounds.height).contains(point) && (index = this.myEmptyTextComponent.findFragmentAt(point.x - x)) >= 0 && index < this.myEmptyTextClickListeners.size()) {
            return this.myEmptyTextClickListeners.get(index);
        }
        return null;
    }

    public String getEmptyText() {
        return this.myEmptyText;
    }

    public void setEmptyText(String emptyText) {
        this.clearEmptyText();
        this.appendEmptyText(emptyText, SimpleTextAttributes.REGULAR_ATTRIBUTES);
    }

    public void clearEmptyText() {
        this.myEmptyTextComponent.clear();
        this.myEmptyTextClickListeners.clear();
        this.myEmptyText = "";
    }

    public void appendEmptyText(String text, SimpleTextAttributes attrs) {
        this.appendEmptyText(text, attrs, null);
    }

    public void appendEmptyText(String text, SimpleTextAttributes attrs, ActionListener listener) {
        this.myEmptyText = this.myEmptyText + text;
        this.myEmptyTextComponent.append(text, attrs);
        this.myEmptyTextClickListeners.add(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.isModelEmpty() && this.myEmptyText.length() > 0) {
            this.myEmptyTextComponent.setFont(this.getFont());
            this.myEmptyTextComponent.setBackground(this.getBackground());
            this.myEmptyTextComponent.setForeground(this.getForeground());
            Rectangle bounds = this.getBounds();
            Dimension size = this.myEmptyTextComponent.getPreferredSize();
            this.myEmptyTextComponent.setBounds(0, 0, size.width, size.height);
            int x = (bounds.width - size.width) / 2;
            Graphics g2 = g.create(bounds.x + x, bounds.y + 20, size.width, size.height);
            try {
                this.myEmptyTextComponent.paint(g2);
            }
            finally {
                g2.dispose();
            }
        }
    }

    public boolean isModelEmpty() {
        TreeModel model = this.getModel();
        return model.getChildCount(model.getRoot()) == 0;
    }
}

