/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.ui;

import com.intellij.openapi.util.SystemInfo;
import com.intellij.util.ui.UIUtil;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.dnd.Autoscroll;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.lang.reflect.Array;
import java.util.ArrayList;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.plaf.TreeUI;
import javax.swing.text.Position;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.Nullable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Tree
extends JTree
implements Autoscroll {
    private static final int AUTOSCROLL_MARGIN = 10;

    public Tree() {
        this.patchTree();
    }

    public Tree(TreeModel treemodel) {
        super(treemodel);
        this.patchTree();
    }

    public Tree(TreeNode root) {
        super(root);
        this.patchTree();
    }

    private void patchTree() {
        this.addMouseListener(new MyMouseListener());
        this.addFocusListener(new MyFocusListener());
    }

    @Override
    protected void processMouseEvent(MouseEvent e) {
        if (SystemInfo.isMac && SwingUtilities.isLeftMouseButton(e) && e.isControlDown() && e.getID() == 501) {
            int modifiers = e.getModifiers() & 0xFFFFFFED | 4;
            e = new MouseEvent(e.getComponent(), e.getID(), e.getWhen(), modifiers, e.getX(), e.getY(), e.getClickCount(), true, 3);
        }
        super.processMouseEvent(e);
    }

    @Override
    public TreePath getNextMatch(String prefix, int startingRow, Position.Bias bias) {
        return null;
    }

    @Override
    public Insets getAutoscrollInsets() {
        return new Insets(this.getLocation().y + 10, 0, this.getParent().getHeight() - 10, this.getWidth() - 1);
    }

    @Override
    public void autoscroll(Point p) {
        int realrow = this.getClosestRowForLocation(p.x, p.y);
        if (this.getLocation().y + p.y <= 10) {
            if (realrow >= 1) {
                --realrow;
            }
        } else if (realrow < this.getRowCount() - 1) {
            ++realrow;
        }
        this.scrollRowToVisible(realrow);
    }

    public final void setLineStyleAngled() {
        UIUtil.setLineStyleAngled(this);
    }

    public <T> T[] getSelectedNodes(Class<T> nodeType, @Nullable NodeFilter<T> filter) {
        TreePath[] paths = this.getSelectionPaths();
        if (paths == null) {
            return (Object[])Array.newInstance(nodeType, 0);
        }
        ArrayList<Object> nodes = new ArrayList<Object>();
        for (int i = 0; i < paths.length; ++i) {
            Object last = paths[i].getLastPathComponent();
            if (!nodeType.isAssignableFrom(last.getClass()) || filter != null && !filter.accept(last)) continue;
            nodes.add(last);
        }
        Object[] result = (Object[])Array.newInstance(nodeType, nodes.size());
        nodes.toArray(result);
        return result;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface NodeFilter<T> {
        public boolean accept(T var1);
    }

    private class MyFocusListener
    extends FocusAdapter {
        private MyFocusListener() {
        }

        private void focusChanges() {
            TreePath[] paths = Tree.this.getSelectionPaths();
            if (paths != null) {
                TreeUI ui = Tree.this.getUI();
                for (int i = paths.length - 1; i >= 0; --i) {
                    Rectangle bounds = ui.getPathBounds(Tree.this, paths[i]);
                    if (bounds == null) continue;
                    Tree.this.repaint(bounds);
                }
            }
        }

        public void focusGained(FocusEvent e) {
            this.focusChanges();
        }

        public void focusLost(FocusEvent e) {
            this.focusChanges();
        }
    }

    private class MyMouseListener
    extends MouseAdapter {
        private MyMouseListener() {
        }

        public void mousePressed(MouseEvent mouseevent) {
            TreePath treepath;
            if (!SwingUtilities.isLeftMouseButton(mouseevent) && (SwingUtilities.isRightMouseButton(mouseevent) || SwingUtilities.isMiddleMouseButton(mouseevent)) && (treepath = Tree.this.getPathForLocation(mouseevent.getX(), mouseevent.getY())) != null) {
                TreePath[] selectionPaths;
                if (Tree.this.getSelectionModel().getSelectionMode() != 1 && (selectionPaths = Tree.this.getSelectionModel().getSelectionPaths()) != null) {
                    for (TreePath selectionPath : selectionPaths) {
                        if (selectionPath != treepath) continue;
                        return;
                    }
                }
                Tree.this.getSelectionModel().setSelectionPath(treepath);
            }
        }
    }
}

