/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.ui;

import com.intellij.openapi.Disposable;

public abstract class Timer
implements Disposable {
    private Thread myThread;
    private int mySpan;
    private boolean myRunning;
    private boolean myDisposed;
    private boolean myRestartRequest;
    private String myName;
    private boolean myTakeInitialDelay = true;
    private boolean myInitiallySlept = false;
    private boolean myInterruptRequest;

    public Timer(String name, int span) {
        this.myName = name;
        this.mySpan = span;
        this.myThread = new Thread(name){

            public void run() {
                try {
                    while (!Timer.this.myInterruptRequest) {
                        if (Timer.this.myTakeInitialDelay || Timer.this.myInitiallySlept) {
                            1.sleep(Timer.this.mySpan);
                        }
                        Timer.this.myInitiallySlept = true;
                        if (Timer.this.myRestartRequest) {
                            Timer.this.myRestartRequest = false;
                            continue;
                        }
                        if (!Timer.this.myRunning) continue;
                        Timer.this.onTimer();
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                Timer.this.myDisposed = true;
            }
        };
    }

    public void setTakeInitialDelay(boolean take) {
        this.myTakeInitialDelay = take;
    }

    public final int getSpan() {
        return this.mySpan;
    }

    public final void start() {
        assert (!this.myThread.isAlive());
        this.myThread.start();
    }

    protected abstract void onTimer() throws InterruptedException;

    public final void suspend() {
        if (this.myDisposed) {
            return;
        }
        if (this.myThread.isAlive()) {
            this.myRunning = false;
        }
        this.myInitiallySlept = false;
    }

    public final void resume() {
        this.startIfNeeded();
        this.myRunning = true;
    }

    private void startIfNeeded() {
        if (this.myDisposed) {
            return;
        }
        if (!this.myThread.isAlive()) {
            this.start();
        }
    }

    public final void dispose() {
        if (this.myThread.isAlive()) {
            this.myInterruptRequest = true;
            this.myThread.interrupt();
            this.myDisposed = true;
            this.myThread = null;
        }
    }

    public void restart() {
        this.startIfNeeded();
        this.myRestartRequest = true;
    }

    public boolean isTimerThread() {
        return Thread.currentThread() == this.myThread;
    }

    public String toString() {
        return "Timer=" + this.myName;
    }

    public boolean isRunning() {
        return this.myRunning;
    }

    public boolean isDisposed() {
        return this.myDisposed;
    }
}

